import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import { AuthProvider } from "./hooks/use-auth";
import { ThemeProvider } from "./components/theme-provider";
import { ProtectedRoute } from "./lib/protected-route";
import { SEOHead } from "@/components/SEOHead";

import HomePage from "@/pages/home-page";
import AuthPage from "@/pages/auth-page";
import DashboardPage from "@/pages/dashboard-page";
import AdminDashboard from "@/pages/admin-dashboard-new";
import CommunityPage from "@/pages/community-page";
import BusinessDirectory from "@/pages/business-directory";
import TermsPage from "@/pages/terms-page";
import ThankYouPage from "@/pages/thankyou-page";
import { DataDealsPage } from "@/pages/data-deals-page";
import HostingPage from "@/pages/hosting-page";
import WebsiteEditor from "@/pages/website-editor";
import AdminHeaderTags from "@/pages/admin-header-tags";
import AdminSeoManagement from "@/pages/admin-seo-management";
import AdminDataDealsEmailPage from "@/pages/admin-data-deals-email-page";
import AdminCustomerEmailPage from "@/pages/admin-customer-email-page";
import AdminBusinessImages from "@/pages/admin-business-images";
import AdminFeaturedBusinesses from "@/pages/admin-featured-businesses";
import AdminBusinessApprovals from "@/pages/admin-business-approvals";
import AdminBusinessImport from "@/pages/admin-business-import";
import NotFound from "@/pages/not-found";

function Router() {
  return (
    <Switch>
      <Route path="/" component={HomePage} />
      <Route path="/auth" component={AuthPage} />
      <Route path="/community" component={CommunityPage} />
      <Route path="/data-deals" component={DataDealsPage} />
      <Route path="/hosting" component={HostingPage} />
      <Route path="/directory" component={BusinessDirectory} />
      <Route path="/terms" component={TermsPage} />
      <Route path="/thankyou" component={ThankYouPage} />
      <ProtectedRoute path="/dashboard" component={DashboardPage} />
      <ProtectedRoute path="/admin" component={AdminDashboard} />
      <ProtectedRoute path="/admin/website-editor" component={WebsiteEditor} />
      <ProtectedRoute path="/admin/header-tags" component={AdminHeaderTags} />
      <ProtectedRoute path="/admin/seo-management" component={AdminSeoManagement} />
      <ProtectedRoute path="/admin/data-deals/email-settings" component={AdminDataDealsEmailPage} />
      <ProtectedRoute path="/admin/data-deals/customer-email-settings" component={AdminCustomerEmailPage} />
      <ProtectedRoute path="/admin/business-images" component={AdminBusinessImages} />
      <ProtectedRoute path="/admin/featured-businesses" component={AdminFeaturedBusinesses} />
      <ProtectedRoute path="/admin/business-approvals" component={AdminBusinessApprovals} />
      <ProtectedRoute path="/admin/business-import" component={AdminBusinessImport} />
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <ThemeProvider>
        <AuthProvider>
          <TooltipProvider>
            <SEOHead />
            <Toaster />
            <Router />
          </TooltipProvider>
        </AuthProvider>
      </ThemeProvider>
    </QueryClientProvider>
  );
}

export default App;
