import { Link } from "wouter";
import { Button } from "@/components/ui/button";
import { useMutation, useQueryClient } from "@tanstack/react-query";
import { apiRequest } from "@/lib/queryClient";
import { 
  Heart, Edit, Settings, Search, Mail, Image, Star, LogOut, 
  Users, CheckSquare, DollarSign 
} from "lucide-react";

export default function AdminHeader() {
  const queryClient = useQueryClient();

  const logoutMutation = useMutation({
    mutationFn: () => apiRequest("/api/auth/logout", "POST"),
    onSuccess: () => {
      queryClient.clear();
      window.location.href = "/";
    },
  });

  return (
    <header className="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between items-center h-16">
          <div className="flex items-center space-x-4">
            <Link href="/" className="flex items-center space-x-3">
              <div className="w-10 h-10 bg-gradient-to-br from-red-500 to-pink-500 rounded-full flex items-center justify-center">
                <Heart className="w-5 h-5 text-white" />
              </div>
              <div>
                <h1 className="text-lg font-bold text-gray-900 dark:text-white">LoveMedia Foundation</h1>
                <p className="text-xs text-gray-500 dark:text-gray-400">Admin Dashboard</p>
              </div>
            </Link>
          </div>

          <div className="flex items-center space-x-2 flex-wrap">
            <Link href="/admin/business-approvals">
              <Button variant="outline" size="sm">
                <CheckSquare className="w-4 h-4 mr-2" />
                Business Approvals
              </Button>
            </Link>
            <Link href="/admin/featured-businesses">
              <Button variant="outline" size="sm">
                <Star className="w-4 h-4 mr-2" />
                Featured Businesses
              </Button>
            </Link>
            <Link href="/admin/business-images">
              <Button variant="outline" size="sm">
                <Image className="w-4 h-4 mr-2" />
                Business Images
              </Button>
            </Link>
            <Link href="/admin/website-editor">
              <Button variant="outline" size="sm">
                <Edit className="w-4 h-4 mr-2" />
                Website Editor
              </Button>
            </Link>
            <Link href="/admin/header-tags">
              <Button variant="outline" size="sm">
                <Settings className="w-4 h-4 mr-2" />
                Header Tags
              </Button>
            </Link>
            <Link href="/admin/seo-management">
              <Button variant="outline" size="sm">
                <Search className="w-4 h-4 mr-2" />
                SEO Management
              </Button>
            </Link>
            <Link href="/admin/data-deals/email-settings">
              <Button variant="outline" size="sm">
                <Mail className="w-4 h-4 mr-2" />
                Data Deals Email
              </Button>
            </Link>
            <Link href="/admin/data-deals/customer-email-settings">
              <Button variant="outline" size="sm">
                <Heart className="w-4 h-4 mr-2" />
                Customer Email
              </Button>
            </Link>
            <Link href="/dashboard">
              <Button variant="outline" size="sm">
                Dashboard
              </Button>
            </Link>
            <Button 
              variant="ghost" 
              size="sm"
              onClick={() => logoutMutation.mutate()}
              disabled={logoutMutation.isPending}
              className="text-red-500 hover:text-red-600"
            >
              <LogOut className="w-4 h-4 mr-2" />
              Logout
            </Button>
          </div>
        </div>
      </div>
    </header>
  );
}