import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Building, Wifi, Signal, Handshake, Store, Percent, Star, MapPin } from "lucide-react";
import { Link } from "wouter";

export default function BusinessDirectorySection() {
  return (
    <section id="directory" className="py-20 bg-white dark:bg-gray-900">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-6">
            Business Directory
          </h2>
          <p className="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
            Supporting local South African businesses with discounted products and services that save thousands monthly
          </p>
        </div>

        {/* Pricing Transparency */}
        <div className="bg-gradient-to-br from-red-50 to-pink-50 dark:from-red-900/20 dark:to-pink-900/20 rounded-2xl p-8 mb-12">
          <div className="text-center mb-8">
            <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">Transparent Pricing</h3>
            <p className="text-gray-600 dark:text-gray-400">As a non-profit, we offer wholesale rates with only a 5% admin fee</p>
          </div>

          <div className="grid md:grid-cols-3 gap-6">
            <Card className="bg-white dark:bg-gray-800 shadow-lg">
              <CardContent className="p-6 text-center">
                <Wifi className="w-12 h-12 text-blue-500 mx-auto mb-4" />
                <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">4G Internet Access</h4>
                <p className="text-sm text-gray-600 dark:text-gray-400 mb-4">High-speed mobile internet for businesses</p>
                <div className="text-2xl font-bold text-red-500">Wholesale + 5%</div>
              </CardContent>
            </Card>

            <Card className="bg-white dark:bg-gray-800 shadow-lg">
              <CardContent className="p-6 text-center">
                <Signal className="w-12 h-12 text-green-500 mx-auto mb-4" />
                <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">5G Internet Access</h4>
                <p className="text-sm text-gray-600 dark:text-gray-400 mb-4">Ultra-fast next-gen connectivity</p>
                <div className="text-2xl font-bold text-red-500">Wholesale + 5%</div>
              </CardContent>
            </Card>

            <Card className="bg-white dark:bg-gray-800 shadow-lg">
              <CardContent className="p-6 text-center">
                <Handshake className="w-12 h-12 text-orange-500 mx-auto mb-4" />
                <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">Partner Deals</h4>
                <p className="text-sm text-gray-600 dark:text-gray-400 mb-4">Special community partnerships</p>
                <div className="text-2xl font-bold text-red-500">Member Rates</div>
              </CardContent>
            </Card>
          </div>
        </div>

        {/* Directory Features */}
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          <div className="text-center">
            <div className="w-16 h-16 bg-gradient-to-br from-red-500 to-pink-500 rounded-full flex items-center justify-center mx-auto mb-4">
              <Store className="w-8 h-8 text-white" />
            </div>
            <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">Local Businesses</h4>
            <p className="text-gray-600 dark:text-gray-400 text-sm">Connect with South African businesses</p>
          </div>

          <div className="text-center">
            <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-teal-500 rounded-full flex items-center justify-center mx-auto mb-4">
              <Percent className="w-8 h-8 text-white" />
            </div>
            <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">Special Offers</h4>
            <p className="text-gray-600 dark:text-gray-400 text-sm">Exclusive deals for community members</p>
          </div>

          <div className="text-center">
            <div className="w-16 h-16 bg-gradient-to-br from-orange-500 to-red-500 rounded-full flex items-center justify-center mx-auto mb-4">
              <Star className="w-8 h-8 text-white" />
            </div>
            <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">Reviews & Ratings</h4>
            <p className="text-gray-600 dark:text-gray-400 text-sm">Community-verified business reviews</p>
          </div>

          <div className="text-center">
            <div className="w-16 h-16 bg-gradient-to-br from-green-500 to-blue-500 rounded-full flex items-center justify-center mx-auto mb-4">
              <MapPin className="w-8 h-8 text-white" />
            </div>
            <h4 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">Local Focus</h4>
            <p className="text-gray-600 dark:text-gray-400 text-sm">Supporting the Dolphin Coast economy</p>
          </div>
        </div>

        {/* CTA for Business Directory */}
        <div className="text-center mt-12">
          <Button
            className="bg-gradient-to-r from-red-500 to-pink-500 hover:from-red-600 hover:to-pink-600 text-white px-8 py-4 rounded-full font-semibold text-lg shadow-xl hover:shadow-2xl transform hover:scale-105 transition-all duration-200"
            asChild
          >
            <Link href="/directory">
              <Building className="w-5 h-5 mr-2" />
              Access Business Directory
            </Link>
          </Button>
        </div>
      </div>
    </section>
  );
}
