import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { Link } from "wouter";
import { 
  Wifi, 
  Server, 
  Heart, 
  Zap, 
  Shield, 
  Globe,
  ArrowRight,
  Star,
  TrendingDown
} from "lucide-react";

export default function DealsSection() {
  return (
    <section className="py-20 bg-gradient-to-br from-blue-50 via-purple-50 to-pink-50 dark:from-gray-800 dark:via-gray-900 dark:to-gray-800 relative overflow-hidden">
      {/* Background decorative elements */}
      <div className="absolute inset-0 opacity-10">
        <div className="absolute top-1/4 left-1/4 w-64 h-64 bg-blue-400 rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute bottom-1/4 right-1/4 w-96 h-96 bg-purple-400 rounded-full blur-3xl animate-pulse" style={{animationDelay: '2s'}}></div>
      </div>
      
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {/* Section Header */}
        <div className="text-center mb-16">
          <Badge className="mb-4 bg-gradient-to-r from-blue-600 to-purple-600 text-white px-6 py-2">
            <Heart className="w-4 h-4 mr-2" />
            Non-Profit Savings
          </Badge>
          <h2 className="text-4xl md:text-5xl font-bold text-gray-900 dark:text-white mb-6">
            Exclusive Community
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-600"> Tech Deals</span>
          </h2>
          <p className="text-xl text-gray-600 dark:text-gray-300 max-w-3xl mx-auto mb-8">
            As a non-profit organization, we've negotiated extremely affordable rates for our community members. 
            All savings are passed directly to you, with proceeds supporting local charities.
          </p>
          
          {/* Key Benefits */}
          <div className="flex flex-wrap justify-center gap-6 mb-8">
            <div className="flex items-center gap-2 bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm rounded-full px-4 py-2">
              <TrendingDown className="w-5 h-5 text-green-600" />
              <span className="text-sm font-medium text-gray-800 dark:text-gray-200">Negotiated Low Prices</span>
            </div>
            <div className="flex items-center gap-2 bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm rounded-full px-4 py-2">
              <Heart className="w-5 h-5 text-red-500" />
              <span className="text-sm font-medium text-gray-800 dark:text-gray-200">Supports Charity</span>
            </div>
            <div className="flex items-center gap-2 bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm rounded-full px-4 py-2">
              <Shield className="w-5 h-5 text-blue-600" />
              <span className="text-sm font-medium text-gray-800 dark:text-gray-200">Non-Profit Guarantee</span>
            </div>
          </div>
        </div>

        {/* Deals Grid */}
        <div className="grid lg:grid-cols-2 gap-8 max-w-6xl mx-auto">
          
          {/* 4G/5G Data Deals Card */}
          <Card className="relative overflow-hidden border-0 shadow-2xl bg-gradient-to-br from-blue-600 to-blue-800 text-white hover:scale-105 transition-all duration-300">
            <div className="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -translate-y-16 translate-x-16"></div>
            <div className="absolute bottom-0 left-0 w-40 h-40 bg-white/5 rounded-full translate-y-20 -translate-x-20"></div>
            
            <CardContent className="p-8 relative z-10">
              <div className="flex items-center gap-3 mb-6">
                <div className="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center">
                  <Wifi className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h3 className="text-2xl font-bold">4G/5G Uncapped Data</h3>
                  <p className="text-blue-100">High-speed mobile internet</p>
                </div>
              </div>
              
              <div className="space-y-4 mb-8">
                <div className="flex items-center gap-2">
                  <Zap className="w-5 h-5 text-yellow-300" />
                  <span>Uncapped data from R299/month</span>
                </div>
                <div className="flex items-center gap-2">
                  <Shield className="w-5 h-5 text-green-300" />
                  <span>Priority streaming & gaming protocols</span>
                </div>
                <div className="flex items-center gap-2">
                  <Star className="w-5 h-5 text-yellow-300" />
                  <span>No contracts • Instant activation</span>
                </div>
              </div>

              {/* Pricing Preview */}
              <div className="bg-white/10 backdrop-blur-sm rounded-lg p-4 mb-6">
                <div className="flex justify-between items-center mb-2">
                  <span className="text-blue-100">Popular Plans:</span>
                </div>
                <div className="space-y-1 text-sm">
                  <div className="flex justify-between">
                    <span>Uncapped 2Mbps</span>
                    <span className="font-semibold">R337/month</span>
                  </div>
                  <div className="flex justify-between">
                    <span>Uncapped 10Mbps</span>
                    <span className="font-semibold">R387/month</span>
                  </div>
                  <div className="flex justify-between">
                    <span>Full Speed Premium</span>
                    <span className="font-semibold">R1199/month</span>
                  </div>
                </div>
              </div>

              {/* Charity Donation */}
              <div className="bg-gradient-to-r from-red-500/20 to-pink-500/20 backdrop-blur-sm rounded-lg p-4 mb-6 border border-red-300/30">
                <div className="flex items-center gap-2 mb-2">
                  <Heart className="w-5 h-5 text-red-300" />
                  <span className="font-semibold text-red-100">Community Impact</span>
                </div>
                <p className="text-sm text-red-100">
                  <strong>R200 donated</strong> to LoveMedia Foundation NPC and TAFTA from each data SIM sale
                </p>
              </div>

              <Button 
                asChild
                size="lg" 
                className="w-full bg-white text-blue-600 hover:bg-blue-50 font-semibold"
              >
                <Link href="/data-deals" className="flex items-center justify-center gap-2">
                  View Data Deals
                  <ArrowRight className="w-5 h-5" />
                </Link>
              </Button>
            </CardContent>
          </Card>

          {/* Web Hosting Card */}
          <Card className="relative overflow-hidden border-0 shadow-2xl bg-gradient-to-br from-purple-600 to-purple-800 text-white hover:scale-105 transition-all duration-300">
            <div className="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -translate-y-16 translate-x-16"></div>
            <div className="absolute bottom-0 left-0 w-40 h-40 bg-white/5 rounded-full translate-y-20 -translate-x-20"></div>
            
            <CardContent className="p-8 relative z-10">
              <div className="flex items-center gap-3 mb-6">
                <div className="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center">
                  <Server className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h3 className="text-2xl font-bold">Premium Web Hosting</h3>
                  <p className="text-purple-100">Professional CPanel hosting</p>
                </div>
              </div>
              
              <div className="space-y-4 mb-8">
                <div className="flex items-center gap-2">
                  <Globe className="w-5 h-5 text-green-300" />
                  <span>Free .co.za domain included</span>
                </div>
                <div className="flex items-center gap-2">
                  <Shield className="w-5 h-5 text-green-300" />
                  <span>Free SSL certificate & CPanel access</span>
                </div>
                <div className="flex items-center gap-2">
                  <Zap className="w-5 h-5 text-yellow-300" />
                  <span>Instant activation • No setup fees</span>
                </div>
              </div>

              {/* Pricing Preview */}
              <div className="bg-white/10 backdrop-blur-sm rounded-lg p-4 mb-6">
                <div className="flex justify-between items-center mb-2">
                  <span className="text-purple-100">Hosting Plans:</span>
                </div>
                <div className="space-y-1 text-sm">
                  <div className="flex justify-between">
                    <span>One Lite (2GB)</span>
                    <span className="font-semibold">R129/month</span>
                  </div>
                  <div className="flex justify-between">
                    <span>One (5GB)</span>
                    <span className="font-semibold">R149/month</span>
                  </div>
                  <div className="flex justify-between">
                    <span>One Pro (10GB)</span>
                    <span className="font-semibold">R299/month</span>
                  </div>
                </div>
              </div>

              {/* Charity Donation */}
              <div className="bg-gradient-to-r from-red-500/20 to-pink-500/20 backdrop-blur-sm rounded-lg p-4 mb-6 border border-red-300/30">
                <div className="flex items-center gap-2 mb-2">
                  <Heart className="w-5 h-5 text-red-300" />
                  <span className="font-semibold text-red-100">Community Impact</span>
                </div>
                <p className="text-sm text-red-100">
                  <strong>R100 donated</strong> to LoveBallito and TAFTA from each hosting sale
                </p>
              </div>

              <Button 
                asChild
                size="lg" 
                className="w-full bg-white text-purple-600 hover:bg-purple-50 font-semibold"
              >
                <Link href="/hosting" className="flex items-center justify-center gap-2">
                  View Hosting Plans
                  <ArrowRight className="w-5 h-5" />
                </Link>
              </Button>
            </CardContent>
          </Card>
        </div>

        {/* Bottom CTA */}
        <div className="text-center mt-16">
          <div className="bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm rounded-2xl p-8 max-w-2xl mx-auto border border-gray-200/50">
            <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">
              Why Choose Our Community Deals?
            </h3>
            <p className="text-gray-600 dark:text-gray-300 mb-6">
              As a registered non-profit (NPC), we negotiate directly with service providers to secure 
              the lowest possible rates for our 12,000+ community members. Every purchase helps fund 
              local community programs and initiatives.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild variant="outline" className="border-2">
                <Link href="/community">Join Our Community</Link>
              </Button>
              <Button asChild className="bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700">
                <Link href="/#contact">Contact Us</Link>
              </Button>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}