import { useState } from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';
import { Separator } from '@/components/ui/separator';
import { CheckCircle, Server, Globe, Zap, Shield, Heart, ExternalLink } from 'lucide-react';
import { SEOHead, seoData } from '@/components/SEOHead';
import Navigation from '@/components/navigation';
import Footer from '@/components/footer';

// Hosting plans data from OpenWeb
const hostingPlans = [
  {
    id: 'one-lite',
    name: 'One Lite',
    price: 129,
    badge: 'PROMOTION',
    popular: false,
    description: 'Perfect for personal blogs and small websites',
    signupUrl: 'https://hosting.openweb.co.za/index.php?rp=/store/shared-web-hosting/super-affordable-package',
    features: [
      'Cpanel Control Panel Access',
      'No setup fee',
      '2GB disk space',
      'Unlimited traffic',
      '10 Email accounts',
      '1 x MYSQL Databases',
      'Latest PHP version',
      'FREE .co.za domain name',
      'Free website builder',
      'Access over 400 x one click install scripts including Wordpress',
      'Free SSL certificate'
    ]
  },
  {
    id: 'one',
    name: 'One',
    price: 149,
    badge: 'HOSTING',
    popular: true,
    description: 'Great for small businesses and growing websites',
    signupUrl: 'https://hosting.openweb.co.za/index.php?rp=/store/shared-web-hosting/one',
    features: [
      'Cpanel Control Panel Access',
      'FREE .co.za Domain Name',
      'No setup fee',
      '5GB disk space',
      'Unlimited traffic',
      '50 Email accounts',
      '10 x MYSQL Databases',
      'Latest PHP version',
      'Free website builder',
      'Access over 400 x one click install scripts including Wordpress',
      'Free SSL certificate'
    ]
  },
  {
    id: 'one-pro',
    name: 'One Pro',
    price: 299,
    badge: 'HOSTING',
    popular: false,
    description: 'Perfect for medium-sized businesses with multiple projects',
    signupUrl: 'https://hosting.openweb.co.za/index.php?rp=/store/shared-web-hosting/one-pro',
    features: [
      'Cpanel Control Panel Access',
      'No setup fee',
      '10GB disk space',
      'Unlimited traffic',
      '100 Email accounts',
      '100 x MYSQL Databases',
      'Latest PHP version',
      'Free .co.za domain or transfer your own',
      'Free website builder',
      'Access over 400 x one click install scripts including Wordpress',
      'Free SSL certificate'
    ]
  },
  {
    id: 'one-prime',
    name: 'One Prime',
    price: 399,
    badge: 'HOSTING',
    popular: false,
    description: 'Advanced hosting for large businesses and multiple websites',
    signupUrl: 'https://hosting.openweb.co.za/index.php?rp=/store/shared-web-hosting/one-prime',
    features: [
      'Cpanel Control Panel Access',
      'No setup fee',
      '50GB disk space',
      'Unlimited traffic',
      'Unlimited Email accounts',
      'Unlimited x MYSQL Databases',
      'Latest PHP version',
      'Free .co.za domain or transfer your own',
      'Free Premium website builder',
      'Access over 400 x one click install scripts including Wordpress',
      'Free SSL certificate'
    ]
  },
  {
    id: 'one-vip',
    name: 'One VIP',
    price: 499,
    badge: 'HOSTING',
    popular: false,
    description: 'Enterprise-level hosting with maximum resources',
    signupUrl: 'https://hosting.openweb.co.za/index.php?rp=/store/shared-web-hosting/one-vip',
    features: [
      'Cpanel Control Panel Access',
      'No setup fee',
      '100GB disk space',
      'Unlimited traffic',
      'Unlimited Email accounts',
      'Unlimited x MYSQL Databases',
      'Latest PHP version',
      'Free .co.za domain or transfer your own',
      'Free Premium website builder',
      'Access over 400 x one click install scripts including Wordpress',
      'Free SSL certificate'
    ]
  }
];

const benefits = [
  {
    icon: Globe,
    title: 'Worldwide Nodes',
    description: 'Our hosting mirrors your website and email addresses to our worldwide nodes allowing for superfast loading times.'
  },
  {
    icon: Zap,
    title: 'Instant Activation',
    description: 'We will have you moving into your new Virtual Home quicker than a \'State Capture\'.'
  },
  {
    icon: Server,
    title: 'CPanel Access',
    description: 'Cpanel is simply the best Hosting Control Panel in the world. All plans have Cpanel Self Management access.'
  },
  {
    icon: Globe,
    title: 'Free Domain',
    description: 'We offer a complimentary .co.za domain name on selected packages.'
  },
  {
    icon: Shield,
    title: 'Easy Payment',
    description: 'You are able to pay via credit card or debit order for your convenience.'
  }
];

const faqItems = [
  {
    question: 'Do I get a FREE Domain name?',
    answer: 'Get a Free .co.za domain name on most of our plans. This will allow you to create you@yourname.co.za email addresses. With our easy to use website builder, you will be able to design your perfect website in no time.'
  },
  {
    question: 'Do you use Cpanel?',
    answer: 'Yes, all our hosting plans have Cpanel access, allowing you to manage your account yourself with ease. The power of Cpanel is unmatched and only the best will do for our clients.'
  },
  {
    question: 'Why would I need a Dedicated Traffic Pipe?',
    answer: 'Think of the Dedicated Traffic Pipe as your very own Blue Light Brigade. You get a fast, dedicated chunk of network bandwidth to transport you and your entourage to wherever you want to go on the internet. Basically, we reserve a fast, dedicated portion of traffic on our massive cloud network just for you. This means your website will load faster than the Rand drops after a Number One speech.'
  },
  {
    question: 'How do I build a website?',
    answer: 'We have multiple drag and drop website builders, like SiteJet Builder that will allow you to quickly and efficiently design the website of your dreams. It even allows you to setup your own ecommerce online shop!'
  },
  {
    question: 'Can I transfer an existing domain?',
    answer: 'Feel free to bring your own domain name. Our automatic transfer system will allow you to \'bring-and-come\'. We will even host your DNS for you at no extra charge! You can always transfer your domain away from us if needed.'
  },
  {
    question: 'Why do I need a Web Hosting account?',
    answer: 'Hosting your own website can be the start of many exciting and creative ventures. You could host a personal blog, sell products online, or create a business website. What you do online is up to you; getting you online is up to us!'
  }
];

export default function HostingPage() {
  const [selectedPlan, setSelectedPlan] = useState<string | null>(null);

  return (
    <div className="min-h-screen bg-white dark:bg-gray-900 transition-colors duration-300">
      <SEOHead 
        title="Premium Web Hosting South Africa - Fast, Reliable CPanel Hosting | LoveMedia Foundation"
        description="Professional web hosting in South Africa with CPanel, free .co.za domains, unlimited traffic, and instant activation. Premium hosting plans from R129/month with free SSL certificates and 24/7 support."
        keywords="web hosting south africa, cpanel hosting, cheap hosting south africa, domain hosting, website hosting, email hosting, ssl certificate, wordpress hosting, php hosting, mysql hosting"
        canonicalUrl="https://lovemedia.co.za/hosting"
        ogImage="https://lovemedia.co.za/og-hosting.jpg"
      />
      
      <Navigation />
      
      {/* Hero Section */}
      <section className="pt-24 pb-16 bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50 dark:from-gray-800 dark:via-gray-900 dark:to-gray-800">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <Badge className="mb-4 bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300">
              Premium Web Hosting
            </Badge>
            <h1 className="text-4xl md:text-6xl font-bold text-gray-900 dark:text-white mb-6">
              Fast, Reliable South African
              <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-600"> Web Hosting</span>
            </h1>
            <p className="text-xl text-gray-600 dark:text-gray-300 mb-8 max-w-3xl mx-auto">
              Professional web hosting with CPanel control panel, free .co.za domains, and instant activation. 
              Get your website online today with our premium South African hosting solutions.
            </p>
            
            {/* Donation Notice */}
            <div className="bg-gradient-to-r from-red-500 to-pink-500 text-white rounded-lg p-6 mx-auto max-w-2xl mb-8">
              <div className="flex items-center justify-center gap-3 mb-2">
                <Heart className="w-6 h-6" />
                <h3 className="text-lg font-semibold">Supporting Our Community</h3>
              </div>
              <p className="text-sm opacity-90">
                R100 from each hosting sale is donated to LoveBallito and TAFTA to support our local community initiatives and programs.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Pricing Plans */}
      <section className="py-20 bg-white dark:bg-gray-900">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
              Choose Your Perfect Hosting Plan
            </h2>
            <p className="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
              All plans include CPanel access, free SSL certificates, and unlimited traffic. 
              Scale as your business grows with our flexible hosting solutions.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-8">
            {hostingPlans.map((plan, index) => (
              <Card 
                key={plan.id}
                className={`relative transition-all duration-300 hover:shadow-xl ${
                  plan.popular 
                    ? 'border-2 border-blue-500 shadow-lg scale-105' 
                    : 'border border-gray-200 dark:border-gray-700 hover:scale-105'
                }`}
              >
                {plan.popular && (
                  <div className="absolute -top-4 left-1/2 transform -translate-x-1/2">
                    <Badge className="bg-blue-500 text-white px-4 py-1">
                      MOST POPULAR
                    </Badge>
                  </div>
                )}
                
                <CardHeader className="text-center pb-4">
                  <Badge 
                    variant="outline" 
                    className={`mb-2 ${
                      plan.badge === 'PROMOTION' 
                        ? 'bg-green-100 text-green-800 border-green-300' 
                        : 'bg-blue-100 text-blue-800 border-blue-300'
                    }`}
                  >
                    {plan.badge}
                  </Badge>
                  <CardTitle className="text-xl font-bold text-gray-900 dark:text-white">
                    {plan.name}
                  </CardTitle>
                  <p className="text-sm text-gray-600 dark:text-gray-400">
                    {plan.description}
                  </p>
                  <div className="text-center mt-4">
                    <span className="text-4xl font-bold text-gray-900 dark:text-white">
                      R{plan.price}
                    </span>
                    <span className="text-gray-600 dark:text-gray-400">/month</span>
                  </div>
                </CardHeader>
                
                <CardContent>
                  <ul className="space-y-3 mb-6">
                    {plan.features.map((feature, idx) => (
                      <li key={idx} className="flex items-start gap-2 text-sm">
                        <CheckCircle className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                        <span className="text-gray-700 dark:text-gray-300">{feature}</span>
                      </li>
                    ))}
                  </ul>
                  
                  <Button 
                    asChild
                    className={`w-full ${
                      plan.popular 
                        ? 'bg-blue-600 hover:bg-blue-700' 
                        : 'bg-gray-900 hover:bg-gray-800 dark:bg-gray-700 dark:hover:bg-gray-600'
                    }`}
                  >
                    <a 
                      href={plan.signupUrl} 
                      target="_blank" 
                      rel="noopener noreferrer"
                      className="flex items-center justify-center gap-2"
                    >
                      {plan.badge === 'PROMOTION' ? 'SIGNUP NOW' : 'ORDER NOW'}
                      <ExternalLink className="w-4 h-4" />
                    </a>
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Benefits Section */}
      <section className="py-20 bg-gray-50 dark:bg-gray-800">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
              Reliable Hosting with Premium Features
            </h2>
            <p className="text-lg text-gray-600 dark:text-gray-300">
              All the extra features you need for professional web hosting in South Africa
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {benefits.map((benefit, index) => (
              <Card key={index} className="text-center hover:shadow-lg transition-shadow duration-300">
                <CardContent className="pt-8">
                  <div className="w-16 h-16 mx-auto mb-4 bg-blue-100 dark:bg-blue-900 rounded-full flex items-center justify-center">
                    <benefit.icon className="w-8 h-8 text-blue-600 dark:text-blue-400" />
                  </div>
                  <h3 className="text-xl font-semibold text-gray-900 dark:text-white mb-3">
                    {benefit.title}
                  </h3>
                  <p className="text-gray-600 dark:text-gray-300">
                    {benefit.description}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* FAQ Section */}
      <section className="py-20 bg-white dark:bg-gray-900">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
              Frequently Asked Questions
            </h2>
            <p className="text-lg text-gray-600 dark:text-gray-300">
              Everything you need to know about our hosting services
            </p>
          </div>

          <div className="space-y-6">
            {faqItems.map((item, index) => (
              <Card key={index} className="hover:shadow-md transition-shadow duration-300">
                <CardContent className="pt-6">
                  <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-3">
                    {item.question}
                  </h3>
                  <p className="text-gray-600 dark:text-gray-300 leading-relaxed">
                    {item.answer}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Testimonial Section */}
      <section className="py-20 bg-gradient-to-br from-blue-50 to-indigo-100 dark:from-gray-800 dark:to-gray-900">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-8">
            What Our Clients Say
          </h2>
          
          <Card className="max-w-3xl mx-auto">
            <CardContent className="pt-8">
              <blockquote className="text-lg text-gray-700 dark:text-gray-300 mb-6 italic">
                "We just moved our company website to OpenWeb and the process was so simple and seamless. 
                We have 26 x different branches across the country and we will be getting their 5G MTN Fixed 
                service for all branches and their Uncapped SIMs for all our employees. Leon was a star and 
                is helping us migrate all our staff over to their Uncapped SIMs."
              </blockquote>
              <footer className="text-gray-900 dark:text-white font-semibold">
                — Jenny van Buuren
              </footer>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-gradient-to-r from-blue-600 to-purple-600">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl md:text-4xl font-bold text-white mb-6">
            Ready to Get Started?
          </h2>
          <p className="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">
            Join thousands of satisfied customers with our premium South African web hosting. 
            Choose your plan and get online in minutes with instant activation.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button 
              asChild
              size="lg" 
              className="bg-white text-blue-600 hover:bg-gray-100"
            >
              <a href="#pricing" className="scroll-smooth">
                View Hosting Plans
              </a>
            </Button>
            <Button 
              asChild
              size="lg" 
              variant="outline" 
              className="border-white text-white hover:bg-white hover:text-blue-600"
            >
              <a href="/#contact" className="scroll-smooth">
                Contact Support
              </a>
            </Button>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
}