import { useEffect } from 'react';
import { SEOHead, seoData } from '@/components/SEOHead';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Separator } from '@/components/ui/separator';
import { ScrollArea } from '@/components/ui/scroll-area';
import { Shield, FileText, Globe, Lock, Phone, Mail, MapPin } from 'lucide-react';

export default function TermsPage() {
  useEffect(() => {
    // Scroll to top on page load
    window.scrollTo(0, 0);
  }, []);

  return (
    <div className="min-h-screen bg-gradient-to-b from-white to-gray-50 dark:from-gray-900 dark:to-gray-800">
      <SEOHead {...seoData.terms} />
      
      {/* Header */}
      <div className="bg-gradient-to-r from-red-500 to-pink-600 text-white py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <div className="flex items-center justify-center gap-3 mb-4">
              <Shield className="w-12 h-12" />
              <FileText className="w-12 h-12" />
            </div>
            <h1 className="text-4xl md:text-5xl font-bold mb-4">
              Terms of Service & Privacy Policy
            </h1>
            <p className="text-xl text-red-100">
              LoveMedia Foundation 4G/5G Data Services - Last Updated: {new Date().toLocaleDateString()}
            </p>
          </div>
        </div>
      </div>

      {/* Content */}
      <div className="container mx-auto px-4 py-12">
        <div className="max-w-6xl mx-auto">
          <div className="grid gap-8 lg:grid-cols-2">
            
            {/* Terms of Service */}
            <Card className="h-fit">
              <CardHeader>
                <CardTitle className="flex items-center gap-2 text-2xl">
                  <FileText className="w-6 h-6 text-red-500" />
                  Terms of Service
                </CardTitle>
              </CardHeader>
              <CardContent>
                <ScrollArea className="h-[600px] pr-4">
                  <div className="space-y-6 text-sm">
                    
                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">1. Service Agreement</h3>
                      <p className="mb-3">
                        By subscribing to LoveMedia Foundation's 4G/5G data services through our partnership with OpenWeb.co.za, 
                        you agree to these Terms of Service. Our data packages provide high-speed internet connectivity across 
                        South Africa with specialized protocols for streaming and gaming.
                      </p>
                      <p>
                        This agreement is between you, LoveMedia Foundation NPC (Registration: 2024/123456/08), 
                        and our authorized partner OpenWeb (Pty) Ltd.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">2. Data Service Plans</h3>
                      <p className="mb-2"><strong>Available Packages:</strong></p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>100GB Monthly - R299/month</li>
                        <li>200GB Monthly - R499/month</li>
                        <li>500GB Monthly - R899/month</li>
                        <li>1000GB (1TB) Monthly - R1,299/month</li>
                        <li>Unlimited Monthly - R1,799/month</li>
                      </ul>
                      <p>
                        All packages include priority protocols for streaming (Netflix, YouTube, DStv Now) 
                        and gaming (Steam, Epic Games, PlayStation Network, Xbox Live).
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">3. Network Coverage & Performance</h3>
                      <p className="mb-3">
                        Our 4G/5G network provides coverage across major South African cities and towns. 
                        Actual speeds may vary based on location, network congestion, and device capabilities. 
                        Typical speeds range from 10Mbps to 100Mbps.
                      </p>
                      <p>
                        We guarantee 99.5% network uptime excluding scheduled maintenance and force majeure events.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">4. Fair Usage Policy</h3>
                      <p className="mb-2">
                        While we offer unlimited packages, the following fair usage guidelines apply:
                      </p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>No commercial resale of data services</li>
                        <li>No excessive peer-to-peer file sharing (&gt;500GB/month on unlimited plans)</li>
                        <li>No illegal content downloading or sharing</li>
                        <li>No network abuse or hacking attempts</li>
                      </ul>
                      <p>
                        Violation may result in speed throttling or service suspension.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">5. Billing & Payment</h3>
                      <p className="mb-3">
                        Services are billed monthly in advance. Payment methods include EFT, credit card, 
                        and debit orders. Late payments incur a R50 administration fee after 7 days.
                      </p>
                      <p>
                        R200 from each subscription is automatically donated to LoveMedia Foundation 
                        for community development projects across South Africa.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">6. Cancellation & Refunds</h3>
                      <p className="mb-3">
                        You may cancel your service with 30 days written notice. Pro-rata refunds 
                        are available for unused portions of pre-paid services. Setup fees and 
                        equipment costs are non-refundable.
                      </p>
                      <p>
                        We offer a 14-day money-back guarantee for new customers (excluding setup fees).
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">7. Equipment & Installation</h3>
                      <p className="mb-3">
                        We provide 4G/5G routers and SIM cards. Equipment remains our property 
                        and must be returned upon service termination. Damaged or lost equipment 
                        will be charged at replacement cost.
                      </p>
                      <p>
                        Professional installation is available for R299 in major metros.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">8. Limitation of Liability</h3>
                      <p className="mb-3">
                        Our liability is limited to the monthly service fee. We are not liable 
                        for indirect damages, lost profits, or business interruption. 
                        Service interruptions due to maintenance, weather, or third-party issues 
                        are excluded from compensation.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">9. Governing Law</h3>
                      <p>
                        These terms are governed by South African law. Disputes will be resolved 
                        through arbitration in Johannesburg, South Africa, under the Arbitration 
                        Foundation of Southern Africa (AFSA) rules.
                      </p>
                    </section>

                  </div>
                </ScrollArea>
              </CardContent>
            </Card>

            {/* Privacy Policy */}
            <Card className="h-fit">
              <CardHeader>
                <CardTitle className="flex items-center gap-2 text-2xl">
                  <Lock className="w-6 h-6 text-red-500" />
                  Privacy Policy
                </CardTitle>
              </CardHeader>
              <CardContent>
                <ScrollArea className="h-[600px] pr-4">
                  <div className="space-y-6 text-sm">
                    
                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">1. Information We Collect</h3>
                      <p className="mb-2"><strong>Personal Information:</strong></p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>Name, surname, and contact details</li>
                        <li>Physical and postal addresses</li>
                        <li>ID number and banking details</li>
                        <li>Email addresses and phone numbers</li>
                      </ul>
                      <p className="mb-2"><strong>Technical Information:</strong></p>
                      <ul className="list-disc list-inside space-y-1">
                        <li>Device information and IMEI numbers</li>
                        <li>Network usage data and connection logs</li>
                        <li>Location data for network optimization</li>
                        <li>Performance and diagnostic information</li>
                      </ul>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">2. How We Use Your Information</h3>
                      <p className="mb-2">We use your information to:</p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>Provide and maintain data services</li>
                        <li>Process payments and manage accounts</li>
                        <li>Optimize network performance</li>
                        <li>Provide customer support</li>
                        <li>Comply with legal requirements</li>
                        <li>Send service updates and promotional offers</li>
                      </ul>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">3. Data Sharing & Disclosure</h3>
                      <p className="mb-3">
                        We do not sell your personal information. We may share data with:
                      </p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>OpenWeb.co.za for service delivery</li>
                        <li>Payment processors for billing</li>
                        <li>Network partners for connectivity</li>
                        <li>Legal authorities when required by law</li>
                        <li>Auditors and regulatory bodies</li>
                      </ul>
                      <p>
                        All partners are bound by confidentiality agreements and POPIA compliance.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">4. POPIA Compliance</h3>
                      <p className="mb-3">
                        We comply with South Africa's Protection of Personal Information Act (POPIA). 
                        You have the right to:
                      </p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>Access your personal information</li>
                        <li>Correct inaccurate information</li>
                        <li>Delete your personal information</li>
                        <li>Object to processing</li>
                        <li>Data portability</li>
                      </ul>
                      <p>
                        Contact our Information Officer at privacy@lovemedia.foundation for requests.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">5. Data Security</h3>
                      <p className="mb-3">
                        We implement industry-standard security measures including:
                      </p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>256-bit SSL encryption for data transmission</li>
                        <li>Secure data centers with biometric access</li>
                        <li>Regular security audits and penetration testing</li>
                        <li>Employee background checks and training</li>
                        <li>Multi-factor authentication for admin access</li>
                      </ul>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">6. Data Retention</h3>
                      <p className="mb-3">
                        We retain personal information for the duration of service plus:
                      </p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>Account information: 7 years after closure</li>
                        <li>Financial records: 5 years for tax purposes</li>
                        <li>Usage logs: 12 months for network optimization</li>
                        <li>Marketing preferences: Until you unsubscribe</li>
                      </ul>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">7. Cookies & Tracking</h3>
                      <p className="mb-3">
                        Our website uses cookies for functionality and analytics. Types include:
                      </p>
                      <ul className="list-disc list-inside space-y-1 mb-3">
                        <li>Essential cookies for website operation</li>
                        <li>Analytics cookies for usage statistics</li>
                        <li>Marketing cookies for targeted advertising</li>
                      </ul>
                      <p>
                        You can manage cookie preferences in your browser settings.
                      </p>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">8. International Transfers</h3>
                      <p className="mb-3">
                        Personal information may be transferred to service providers outside South Africa. 
                        We ensure adequate protection through:
                      </p>
                      <ul className="list-disc list-inside space-y-1">
                        <li>Standard contractual clauses</li>
                        <li>Adequacy decisions by authorities</li>
                        <li>Binding corporate rules</li>
                      </ul>
                    </section>

                    <Separator />

                    <section>
                      <h3 className="text-lg font-semibold mb-3 text-red-600">9. Contact Information</h3>
                      <div className="space-y-2">
                        <p className="font-medium">LoveMedia Foundation NPC</p>
                        <div className="flex items-center gap-2">
                          <MapPin className="w-4 h-4 text-red-500" />
                          <span>123 Community Drive, Ballito, KwaZulu-Natal, 4420</span>
                        </div>
                        <div className="flex items-center gap-2">
                          <Mail className="w-4 h-4 text-red-500" />
                          <span>privacy@lovemedia.foundation</span>
                        </div>
                        <div className="flex items-center gap-2">
                          <Phone className="w-4 h-4 text-red-500" />
                          <span>+27 32 946 1234</span>
                        </div>
                        <div className="flex items-center gap-2">
                          <Globe className="w-4 h-4 text-red-500" />
                          <span>www.lovemedia.foundation</span>
                        </div>
                      </div>
                    </section>

                  </div>
                </ScrollArea>
              </CardContent>
            </Card>

          </div>
        </div>
      </div>
    </div>
  );
}