import { useEffect } from 'react';
import { Link } from 'wouter';
import { SEOHead } from '@/components/SEOHead';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { CheckCircle, Heart, Smartphone, Globe, ArrowRight, Home } from 'lucide-react';

export default function ThankYouPage() {
  useEffect(() => {
    // Scroll to top on page load
    window.scrollTo(0, 0);
  }, []);

  const seoData = {
    title: "Thank You - Order Confirmed | LoveMedia Foundation",
    description: "Thank you for your data deal order! Your submission has been received and you'll receive confirmation shortly.",
    keywords: "thank you, order confirmation, data deals, 4G 5G internet, South Africa",
    url: "https://lovemedia.foundation/thankyou",
    type: "website"
  };

  return (
    <div className="min-h-screen bg-gradient-to-b from-white to-gray-50 dark:from-gray-900 dark:to-gray-800">
      <SEOHead {...seoData} />
      
      {/* Header */}
      <div className="bg-gradient-to-r from-green-500 to-emerald-600 text-white py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <div className="flex items-center justify-center gap-3 mb-6">
              <CheckCircle className="w-16 h-16 text-green-100" />
            </div>
            <h1 className="text-4xl md:text-5xl font-bold mb-4" data-testid="text-thank-you-title">
              Thank You!
            </h1>
            <p className="text-xl text-green-100" data-testid="text-order-confirmation">
              Your data deal order has been successfully submitted
            </p>
          </div>
        </div>
      </div>

      {/* Content */}
      <div className="container mx-auto px-4 py-12">
        <div className="max-w-4xl mx-auto">
          
          {/* Main Confirmation Card */}
          <Card className="mb-8">
            <CardHeader>
              <CardTitle className="flex items-center gap-2 text-2xl text-center justify-center">
                <Smartphone className="w-6 h-6 text-green-500" />
                Order Confirmed
              </CardTitle>
            </CardHeader>
            <CardContent className="text-center space-y-6">
              <div className="space-y-4">
                <p className="text-lg" data-testid="text-confirmation-message">
                  We've received your order for an OpenWeb 4G/5G data package and it's being processed right now.
                </p>
                
                <div className="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-4">
                  <div className="flex items-center justify-center gap-2 text-green-700 dark:text-green-300 mb-2">
                    <Heart className="w-5 h-5" />
                    <span className="font-semibold">Community Impact</span>
                  </div>
                  <p className="text-green-600 dark:text-green-400" data-testid="text-donation-info">
                    R200 from your order will be donated to LoveMedia Foundation to support community development projects across South Africa.
                  </p>
                </div>
              </div>

              <div className="grid md:grid-cols-2 gap-6 mt-8">
                <div className="text-left space-y-3">
                  <h3 className="font-semibold text-lg flex items-center gap-2">
                    <Globe className="w-5 h-5 text-blue-500" />
                    What happens next?
                  </h3>
                  <ul className="space-y-2 text-sm" data-testid="list-next-steps">
                    <li className="flex items-start gap-2">
                      <ArrowRight className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>You'll receive a confirmation email within 24 hours</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <ArrowRight className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>OpenWeb will contact you to arrange delivery and setup</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <ArrowRight className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>Your 4G/5G router and SIM will be delivered within 3-5 business days</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <ArrowRight className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>Professional installation available in major metros</span>
                    </li>
                  </ul>
                </div>

                <div className="text-left space-y-3">
                  <h3 className="font-semibold text-lg">Package Benefits</h3>
                  <ul className="space-y-2 text-sm" data-testid="list-benefits">
                    <li className="flex items-start gap-2">
                      <CheckCircle className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>High-speed 4G/5G connectivity</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <CheckCircle className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>Priority streaming & gaming protocols</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <CheckCircle className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>Nationwide coverage</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <CheckCircle className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>Month-to-month billing</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <CheckCircle className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                      <span>24/7 technical support</span>
                    </li>
                  </ul>
                </div>
              </div>

              <div className="pt-6 border-t border-gray-200 dark:border-gray-700">
                <p className="text-sm text-gray-600 dark:text-gray-400 mb-4" data-testid="text-support-info">
                  Questions about your order? Contact OpenWeb support at <strong>support@openweb.co.za</strong> or call <strong>0861 OPENWEB</strong>
                </p>
                
                <div className="flex flex-col sm:flex-row gap-4 justify-center">
                  <Button asChild data-testid="button-back-home">
                    <Link href="/">
                      <Home className="w-4 h-4 mr-2" />
                      Back to Home
                    </Link>
                  </Button>
                  
                  <Button variant="outline" asChild data-testid="button-view-data-deals">
                    <Link href="/data-deals">
                      <Smartphone className="w-4 h-4 mr-2" />
                      View Data Deals
                    </Link>
                  </Button>
                </div>
              </div>
            </CardContent>
          </Card>

          {/* Additional Info Card */}
          <Card>
            <CardHeader>
              <CardTitle className="text-center">Need Help?</CardTitle>
            </CardHeader>
            <CardContent className="text-center space-y-4">
              <p className="text-sm text-gray-600 dark:text-gray-400">
                Our team is here to help you get connected. If you have any questions or need assistance, don't hesitate to reach out.
              </p>
              
              <div className="grid sm:grid-cols-2 gap-4 text-sm">
                <div className="p-4 bg-gray-50 dark:bg-gray-800 rounded-lg">
                  <h4 className="font-semibold mb-2">OpenWeb Support</h4>
                  <p>Technical assistance & billing</p>
                  <p className="text-blue-600 dark:text-blue-400">support@openweb.co.za</p>
                  <p className="text-blue-600 dark:text-blue-400">0861 OPENWEB</p>
                </div>
                
                <div className="p-4 bg-gray-50 dark:bg-gray-800 rounded-lg">
                  <h4 className="font-semibold mb-2">LoveMedia Foundation</h4>
                  <p>Community impact & projects</p>
                  <p className="text-blue-600 dark:text-blue-400">hello@lovemedia.foundation</p>
                  <p className="text-blue-600 dark:text-blue-400">+27 11 123 4567</p>
                </div>
              </div>
            </CardContent>
          </Card>

        </div>
      </div>
    </div>
  );
}