# LoveMedia Foundation Community Platform

## Overview
This is a full-stack web application for the LoveMedia Foundation NPC, a non-profit organization connecting over 12,000 community members across South Africa. The platform provides local news, WhatsApp groups, a business directory with 138,000+ businesses, community alerts, and highly discounted products from sponsors, saving members thousands of rands monthly. The project aims to scale to serve the entire South African community across all 9 provinces.

## User Preferences
Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
- **Framework**: React with TypeScript using Vite
- **Styling**: Tailwind CSS with a custom design system
- **UI Components**: Radix UI primitives with shadcn/ui
- **Routing**: Wouter for client-side routing
- **State Management**: TanStack React Query for server state
- **Authentication**: Context-based auth provider with role-based access control

### Backend Architecture
- **Runtime**: Node.js with Express.js
- **Language**: TypeScript with ES modules
- **Session Management**: Express sessions with PostgreSQL store
- **Authentication**: Passport.js with local strategy (scrypt for hashing)
- **API Design**: RESTful endpoints with role-based access control

### Database Architecture
- **Database**: PostgreSQL with Neon serverless hosting
- **ORM**: Drizzle ORM with Zod validation schemas
- **Schema**: Supports users, businesses, content, WhatsApp groups, contact submissions, and system settings.
- **Migrations**: Drizzle Kit for database migrations

### Key Features
- **Authentication System**: Role-based access (admin/client), secure hashing, session-based.
- **Business Directory**: Category and location filtering, contact info, user submissions, verification, "Recommended Businesses" with rotation.
- **Content Management**: Multi-type content (news, alerts, events), publishing workflow, priority levels.
- **Community Features**: WhatsApp group integration, contact forms, member dashboard.
- **Data Deals Partnership System**: Integration with OpenWeb for 4G/5G data packages, order management, automated email processing, admin dashboard.
- **Admin Dashboard**: User management, content moderation, business directory oversight, community statistics, SEO management, email configuration, website editor.
- **SEO Optimization**: Dynamic SEO component, structured data (JSON-LD), sitemap.xml, robots.txt, Open Graph tags, favicon.

## External Dependencies

- **Database**: Neon PostgreSQL serverless database
- **UI Libraries**: Radix UI, shadcn/ui
- **Payment Gateway/API (Implied)**: OpenWeb.co.za (for data deals and web hosting partnerships)
- **Email Service**: For sending automated emails (e.g., order confirmations)
- **Development Tools**: Vite, esbuild, Drizzle Kit, Zod