import { ReactNode } from "react";
import { useAuth } from "@/hooks/use-auth";

interface RoleGuardProps {
  children: ReactNode;
  requiredRole?: "admin" | "staff";
  fallback?: ReactNode;
}

export default function RoleGuard({ children, requiredRole = "staff", fallback = null }: RoleGuardProps) {
  const { user } = useAuth();

  if (!user) {
    return fallback;
  }

  // Admin can access everything
  if (user.role === "admin") {
    return <>{children}</>;
  }

  // Staff can access staff-level content (viewing only)
  if (user.role === "staff" && requiredRole === "staff") {
    return <>{children}</>;
  }

  // Return fallback if access denied
  return <>{fallback}</>;
}