import { useQuery } from "@tanstack/react-query";
import { Card, CardContent } from "@/components/ui/card";
import { Users, IdCard, Signal, BarChart3 } from "lucide-react";
import { useAuth } from "@/hooks/use-auth";

export default function StatsCards() {
  const { data: stats, isLoading } = useQuery({
    queryKey: ["/api/stats"],
  });
  const { user } = useAuth();

  const getCards = () => {
    const allCards = [
      {
        title: "Total Clients",
        value: stats?.totalClients || 0,
        change: "+12%",
        changeType: "positive",
        icon: Users,
        bgColor: "bg-blue-50",
        iconColor: "text-primary",
        adminOnly: true,
      },
      {
        title: "Telkom Clients",
        value: stats?.telkomClients || 0,
        change: "+5%",
        changeType: "positive",
        icon: IdCard,
        bgColor: "bg-green-50",
        iconColor: "text-success",
        adminOnly: true,
      },
      {
        title: "Active SIMs",
        value: stats?.activeSims || 0,
        change: "+8%",
        changeType: "positive",
        icon: Signal,
        bgColor: "bg-orange-50",
        iconColor: "text-warning",
        adminOnly: false,
      },
    ];

    // Filter cards based on user role
    return user?.role === "admin" 
      ? allCards 
      : allCards.filter(card => !card.adminOnly);
  };

  const cards = getCards();

  if (isLoading) {
    return (
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
        {[1, 2, 3].map((i) => (
          <Card key={i} className="animate-pulse">
            <CardContent className="p-6">
              <div className="h-24 bg-gray-200 rounded"></div>
            </CardContent>
          </Card>
        ))}
      </div>
    );
  }

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
      {cards.map((card, index) => {
        const Icon = card.icon;
        return (
          <Card key={index} className="shadow-sm border border-gray-200">
            <CardContent className="p-6">
              <div className="flex items-center justify-between">
                <div>
                  <p className="text-sm font-medium text-gray-600">{card.title}</p>
                  <p className="text-3xl font-bold text-gray-900">{card.value.toLocaleString()}</p>
                </div>
                <div className={`w-12 h-12 ${card.bgColor} rounded-lg flex items-center justify-center`}>
                  <Icon className={card.iconColor} size={24} />
                </div>
              </div>
              <div className="mt-4 flex items-center">
                <span
                  className={`text-sm font-medium ${
                    card.changeType === "positive" ? "text-success" : "text-error"
                  }`}
                >
                  {card.change}
                </span>
                <span className="text-sm text-gray-500 ml-1">from last month</span>
              </div>
            </CardContent>
          </Card>
        );
      })}
    </div>
  );
}
