import { pool } from './db';

export async function createMtnMobileTop15Table(): Promise<void> {
  try {
    console.log('Creating MTN Mobile Top 15 table...');
    
    await pool.query(`
      CREATE TABLE IF NOT EXISTS mtnmobiletop15 (
        id SERIAL PRIMARY KEY,
        account_number VARCHAR(255) NOT NULL,
        client_name VARCHAR(255) NOT NULL,
        msisdn VARCHAR(50),
        total_bytes BIGINT NOT NULL DEFAULT 0,
        connected_time_minutes INTEGER NOT NULL DEFAULT 0,
        year INTEGER NOT NULL,
        month INTEGER NOT NULL,
        rank_position INTEGER,
        sync_timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
        CONSTRAINT unique_account_year_month UNIQUE (account_number, year, month)
      );
    `);
    
    console.log('MTN Mobile Top 15 table created successfully');
  } catch (error) {
    console.error('Error creating MTN Mobile Top 15 table:', error);
    throw error;
  }
}