import { pool } from "./db";

export async function createMtnStatisticsTable(): Promise<void> {
  try {
    const createTableQuery = `
      CREATE TABLE IF NOT EXISTS mtn_statistics (
        id SERIAL PRIMARY KEY,
        username VARCHAR(255) NOT NULL,
        msisdn VARCHAR(20),
        year INTEGER NOT NULL,
        month INTEGER NOT NULL,
        total_bytes BIGINT NOT NULL DEFAULT 0,
        connected_time_minutes INTEGER NOT NULL DEFAULT 0,
        refreshed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        UNIQUE(username, year, month)
      );
    `;
    
    await pool.query(createTableQuery);
    console.log("MTN Statistics table created successfully");
  } catch (error) {
    console.error("Error creating MTN Statistics table:", error);
    throw error;
  }
}