"""
API Server Runner
Standalone Flask API server for external integration
"""

from api import app
from flask_cors import CORS

# Enable CORS for all domains
CORS(app, origins="*")

if __name__ == '__main__':
    print("🚀 Starting SIM Analytics API Server...")
    print("📚 API Documentation: http://0.0.0.0:5001/api/v1/docs")
    print("🔍 Health Check: http://0.0.0.0:5001/api/v1/health")
    
    # Run the Flask API server
    app.run(
        host='0.0.0.0',
        port=5001,
        debug=True,
        use_reloader=False  # Avoid conflicts with Streamlit
    )