import sqlite3

def check_schema():
    conn = sqlite3.connect('sim_analytics.db')
    cursor = conn.cursor()
    
    # Check all tables
    cursor.execute("SELECT name FROM sqlite_master WHERE type='table'")
    tables = cursor.fetchall()
    print("Tables in database:")
    for table in tables:
        print(f"  {table[0]}")
    
    # Check clients table
    print("\n--- CLIENTS TABLE ---")
    cursor.execute("SELECT COUNT(*) FROM clients")
    count = cursor.fetchone()[0]
    print(f"clients has {count} rows")
    
    cursor.execute("SELECT * FROM clients")
    clients = cursor.fetchall()
    print("All clients:")
    for client in clients:
        print(f"  {client}")
    
    # Check usage_records
    print("\n--- USAGE_RECORDS TABLE ---")
    cursor.execute("SELECT COUNT(*) FROM usage_records")
    count = cursor.fetchone()[0]
    print(f"usage_records has {count} rows")
    
    cursor.execute("SELECT * FROM usage_records")
    records = cursor.fetchall()
    print("All usage records:")
    for record in records:
        print(f"  {record}")
    
    # Check sim_numbers
    print("\n--- SIM_NUMBERS TABLE ---")
    cursor.execute("SELECT COUNT(*) FROM sim_numbers")
    count = cursor.fetchone()[0]
    print(f"sim_numbers has {count} rows")
    
    if count > 0:
        cursor.execute("SELECT * FROM sim_numbers")
        sims = cursor.fetchall()
        print("All SIM numbers:")
        for sim in sims:
            print(f"  {sim}")
    
    conn.close()

if __name__ == "__main__":
    check_schema()