--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9
-- Dumped by pg_dump version 16.9

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: api_keys; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.api_keys (
    id integer NOT NULL,
    key_name character varying(255) NOT NULL,
    api_key_hash character varying(255) NOT NULL,
    api_key_prefix character varying(10) NOT NULL,
    key_type character varying(20) NOT NULL,
    created_by character varying(255) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    last_used timestamp without time zone,
    is_active boolean DEFAULT true,
    usage_count integer DEFAULT 0,
    rate_limit_per_hour integer DEFAULT 1000,
    description text,
    CONSTRAINT api_keys_key_type_check CHECK (((key_type)::text = ANY ((ARRAY['admin'::character varying, 'user'::character varying])::text[])))
);


ALTER TABLE public.api_keys OWNER TO neondb_owner;

--
-- Name: api_keys_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.api_keys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.api_keys_id_seq OWNER TO neondb_owner;

--
-- Name: api_keys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.api_keys_id_seq OWNED BY public.api_keys.id;


--
-- Name: api_usage_logs; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.api_usage_logs (
    id integer NOT NULL,
    api_key_id integer,
    endpoint character varying(255) NOT NULL,
    method character varying(10) NOT NULL,
    ip_address inet,
    user_agent text,
    request_data text,
    response_status integer,
    response_time_ms integer,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.api_usage_logs OWNER TO neondb_owner;

--
-- Name: api_usage_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.api_usage_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.api_usage_logs_id_seq OWNER TO neondb_owner;

--
-- Name: api_usage_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.api_usage_logs_id_seq OWNED BY public.api_usage_logs.id;


--
-- Name: clients; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.clients (
    client_id character varying(255) NOT NULL,
    client_name character varying(255) NOT NULL,
    sim_number character varying(255),
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.clients OWNER TO neondb_owner;

--
-- Name: daily_usage; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.daily_usage (
    id integer NOT NULL,
    usage_record_id integer NOT NULL,
    date date NOT NULL,
    usage_gb numeric(10,3) NOT NULL
);


ALTER TABLE public.daily_usage OWNER TO neondb_owner;

--
-- Name: daily_usage_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.daily_usage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.daily_usage_id_seq OWNER TO neondb_owner;

--
-- Name: daily_usage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.daily_usage_id_seq OWNED BY public.daily_usage.id;


--
-- Name: protocol_usage; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.protocol_usage (
    id integer NOT NULL,
    usage_record_id integer NOT NULL,
    protocol_name character varying(255) NOT NULL,
    category character varying(255) NOT NULL,
    usage_gb numeric(10,3) NOT NULL,
    percentage numeric(5,2) NOT NULL
);


ALTER TABLE public.protocol_usage OWNER TO neondb_owner;

--
-- Name: protocol_usage_backup; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.protocol_usage_backup (
    id integer,
    usage_record_id integer,
    protocol_name character varying(255),
    category character varying(255),
    usage_gb numeric(10,3),
    percentage numeric(5,2)
);


ALTER TABLE public.protocol_usage_backup OWNER TO neondb_owner;

--
-- Name: protocol_usage_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.protocol_usage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.protocol_usage_id_seq OWNER TO neondb_owner;

--
-- Name: protocol_usage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.protocol_usage_id_seq OWNED BY public.protocol_usage.id;


--
-- Name: sim_numbers; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.sim_numbers (
    id integer NOT NULL,
    client_id character varying(255) NOT NULL,
    sim_number character varying(255) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    msisdn character varying(20),
    fup_gb integer DEFAULT 100
);


ALTER TABLE public.sim_numbers OWNER TO neondb_owner;

--
-- Name: sim_numbers_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.sim_numbers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sim_numbers_id_seq OWNER TO neondb_owner;

--
-- Name: sim_numbers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.sim_numbers_id_seq OWNED BY public.sim_numbers.id;


--
-- Name: usage_records; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.usage_records (
    id integer NOT NULL,
    client_id character varying(255) NOT NULL,
    total_usage_gb numeric(10,3) NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    fup_reached boolean NOT NULL,
    daily_breakdown text,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    msisdn character varying(20),
    sim_number character varying(50)
);


ALTER TABLE public.usage_records OWNER TO neondb_owner;

--
-- Name: usage_records_backup; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.usage_records_backup (
    id integer,
    client_id character varying(255),
    total_usage_gb numeric(10,3),
    date_from date,
    date_to date,
    fup_reached boolean,
    daily_breakdown text,
    created_at timestamp without time zone,
    msisdn character varying(20),
    sim_number character varying(50)
);


ALTER TABLE public.usage_records_backup OWNER TO neondb_owner;

--
-- Name: usage_records_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.usage_records_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.usage_records_id_seq OWNER TO neondb_owner;

--
-- Name: usage_records_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.usage_records_id_seq OWNED BY public.usage_records.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.users (
    id integer NOT NULL,
    username character varying(50) NOT NULL,
    password_hash character varying(64) NOT NULL,
    role character varying(20) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    last_login timestamp without time zone,
    is_active boolean DEFAULT true,
    CONSTRAINT users_role_check CHECK (((role)::text = ANY ((ARRAY['admin'::character varying, 'staff'::character varying])::text[])))
);


ALTER TABLE public.users OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.users_id_seq OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: api_keys id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_keys ALTER COLUMN id SET DEFAULT nextval('public.api_keys_id_seq'::regclass);


--
-- Name: api_usage_logs id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_usage_logs ALTER COLUMN id SET DEFAULT nextval('public.api_usage_logs_id_seq'::regclass);


--
-- Name: daily_usage id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.daily_usage ALTER COLUMN id SET DEFAULT nextval('public.daily_usage_id_seq'::regclass);


--
-- Name: protocol_usage id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.protocol_usage ALTER COLUMN id SET DEFAULT nextval('public.protocol_usage_id_seq'::regclass);


--
-- Name: sim_numbers id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.sim_numbers ALTER COLUMN id SET DEFAULT nextval('public.sim_numbers_id_seq'::regclass);


--
-- Name: usage_records id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.usage_records ALTER COLUMN id SET DEFAULT nextval('public.usage_records_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Data for Name: api_keys; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.api_keys (id, key_name, api_key_hash, api_key_prefix, key_type, created_by, created_at, last_used, is_active, usage_count, rate_limit_per_hour, description) FROM stdin;
\.


--
-- Data for Name: api_usage_logs; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.api_usage_logs (id, api_key_id, endpoint, method, ip_address, user_agent, request_data, response_status, response_time_ms, created_at) FROM stdin;
\.


--
-- Data for Name: clients; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.clients (client_id, client_name, sim_number, created_at) FROM stdin;
KWright0004	Keoma Wright	\N	2025-08-15 10:15:04.171036
E06815337298597	E Hartzer - 0681533729	\N	2025-08-17 12:24:12.648022
H06584391207400	Hugo Lambrechts 0658439120	\N	2025-08-18 08:28:54.330716
H06583783264620	Hugo Lambrechts 0658378326	\N	2025-08-18 08:29:32.127113
H06583783261526	Hugo Lambrechts 0658378326	\N	2025-08-18 08:29:38.55366
H06779683579311	Hugo Lambrechts 0677968357	\N	2025-08-18 08:30:09.514628
H06956586880106	Hugo Lambrechts 0695658688	\N	2025-08-18 08:30:33.57201
D06932067823015	Deon Naude 0693206782	\N	2025-08-18 13:31:54.220678
C06915630140109	Cornelius vd Westhuizen 0691563014	\N	2025-08-18 13:34:31.739964
W06974145455980	Werniech van Blerk 0697414545	\N	2025-08-19 05:28:33.657513
KDithebe3020	Karabelo Dithebe 	\N	2025-08-19 05:40:22.851467
J08138312825445	Johan Louw 0813831282	\N	2025-08-19 06:53:13.180857
J08152906270400	J Pelser - 0815290627	\N	2025-08-19 14:23:36.535776
A06800854228718	Alwin Friedrich Carstens 0680085422	\N	2025-08-20 06:13:11.288495
K06149099815042	K Reddy - 0614909981	\N	2025-08-20 14:36:21.910113
N06940094359538	 Neo Ramalivhana (T1) 0694009435	\N	2025-08-21 15:07:25.45388
\.


--
-- Data for Name: daily_usage; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.daily_usage (id, usage_record_id, date, usage_gb) FROM stdin;
\.


--
-- Data for Name: protocol_usage; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.protocol_usage (id, usage_record_id, protocol_name, category, usage_gb, percentage) FROM stdin;
2381	179	HTTP	Web	76.883	24.82
2382	179	HTTPS	Web	108.642	35.07
2383	179	YouTube	Video	47.142	15.22
2384	179	Netflix	Video	25.400	8.20
2385	179	WhatsApp	Messaging	9.894	3.19
2386	179	Facebook	Social	13.265	4.28
2387	179	Instagram	Social	8.439	2.72
2388	179	Spotify	Audio	5.646	1.82
2389	179	Teams	Business	5.344	1.72
2390	179	Zoom	Business	9.166	2.96
2391	180	HTTP	Web	96.298	24.72
2392	180	HTTPS	Web	135.206	34.71
2393	180	YouTube	Video	57.390	14.73
2394	180	Netflix	Video	30.041	7.71
2395	180	WhatsApp	Messaging	12.654	3.25
2396	180	Facebook	Social	16.675	4.28
2397	180	Instagram	Social	11.395	2.93
2398	180	Spotify	Audio	7.762	1.99
2399	180	Teams	Business	8.027	2.06
2400	180	Zoom	Business	11.298	2.90
2401	180	Other	Miscellaneous	2.766	0.71
2402	181	HTTP	Web	90.453	24.75
2403	181	HTTPS	Web	127.387	34.86
2404	181	YouTube	Video	55.898	15.30
2405	181	Netflix	Video	29.256	8.01
2406	181	WhatsApp	Messaging	11.098	3.04
2407	181	Facebook	Social	14.990	4.10
2408	181	Instagram	Social	11.259	3.08
2409	181	Spotify	Audio	8.048	2.20
2410	181	Teams	Business	6.608	1.81
2411	181	Zoom	Business	10.322	2.82
2412	181	Other	Miscellaneous	0.080	0.02
2413	182	HTTP	Web	89.634	24.72
2414	182	HTTPS	Web	127.658	35.21
2415	182	YouTube	Video	55.249	15.24
2416	182	Netflix	Video	28.943	7.98
2417	182	WhatsApp	Messaging	11.027	3.04
2418	182	Facebook	Social	14.439	3.98
2419	182	Instagram	Social	11.754	3.24
2420	182	Spotify	Audio	8.144	2.25
2421	182	Teams	Business	6.661	1.84
2422	182	Zoom	Business	10.426	2.88
2423	183	HTTP	Web	91.260	25.23
2424	183	HTTPS	Web	125.557	34.71
2425	183	YouTube	Video	54.407	15.04
2426	183	Netflix	Video	28.996	8.01
2427	183	WhatsApp	Messaging	10.558	2.92
2428	183	Facebook	Social	13.418	3.71
2429	183	Instagram	Social	11.923	3.30
2430	183	Spotify	Audio	7.105	1.96
2431	183	Teams	Business	6.328	1.75
2432	183	Zoom	Business	11.451	3.17
2433	183	Other	Miscellaneous	0.776	0.21
2434	184	HTTP	Web	91.064	24.92
2435	184	HTTPS	Web	128.860	35.26
2436	184	YouTube	Video	55.655	15.23
2437	184	Netflix	Video	28.391	7.77
2438	184	WhatsApp	Messaging	11.229	3.07
2439	184	Facebook	Social	14.827	4.06
2440	184	Instagram	Social	10.634	2.91
2441	184	Spotify	Audio	7.639	2.09
2442	184	Teams	Business	7.981	2.18
2443	184	Zoom	Business	9.873	2.70
2444	185	HTTP	Web	86.874	25.09
2445	185	HTTPS	Web	120.154	34.71
2446	185	YouTube	Video	51.805	14.96
2447	185	Netflix	Video	27.279	7.88
2448	185	WhatsApp	Messaging	10.797	3.12
2449	185	Facebook	Social	13.797	3.99
2450	185	Instagram	Social	10.255	2.96
2451	185	Spotify	Audio	7.773	2.25
2452	185	Teams	Business	6.673	1.93
2453	185	Zoom	Business	9.532	2.75
2454	185	Other	Miscellaneous	1.262	0.36
2455	186	HTTP	Web	83.303	24.72
2456	186	HTTPS	Web	118.583	35.18
2457	186	YouTube	Video	51.476	15.27
2458	186	Netflix	Video	27.416	8.13
2459	186	WhatsApp	Messaging	10.749	3.19
2460	186	Facebook	Social	14.069	4.17
2461	186	Instagram	Social	10.474	3.11
2462	186	Spotify	Audio	7.738	2.30
2463	186	Teams	Business	7.036	2.09
2464	186	Zoom	Business	10.664	3.16
2465	187	HTTP	Web	113.067	24.72
2466	187	HTTPS	Web	160.431	35.07
2467	187	YouTube	Video	67.924	14.85
2468	187	Netflix	Video	36.301	7.94
2469	187	WhatsApp	Messaging	14.160	3.10
2470	187	Facebook	Social	19.510	4.27
2471	187	Instagram	Social	12.644	2.76
2472	187	Spotify	Audio	8.307	1.82
2473	187	Teams	Business	10.220	2.23
2474	187	Zoom	Business	14.906	3.26
2475	188	HTTP	Web	95.388	25.00
2476	188	HTTPS	Web	134.096	35.15
2477	188	YouTube	Video	57.145	14.98
2478	188	Netflix	Video	31.650	8.30
2479	188	WhatsApp	Messaging	10.645	2.79
2480	188	Facebook	Social	14.546	3.81
2481	188	Instagram	Social	11.174	2.93
2482	188	Spotify	Audio	7.653	2.01
2483	188	Teams	Business	7.327	1.92
2484	188	Zoom	Business	12.543	3.29
2485	189	HTTP	Web	108.650	25.03
2486	189	HTTPS	Web	152.103	35.04
2487	189	YouTube	Video	66.135	15.24
2488	189	Netflix	Video	33.617	7.74
2489	189	WhatsApp	Messaging	12.838	2.96
2490	189	Facebook	Social	18.127	4.18
2491	189	Instagram	Social	12.392	2.85
2492	189	Spotify	Audio	7.965	1.84
2493	189	Teams	Business	8.179	1.88
2494	189	Zoom	Business	13.156	3.03
2495	189	Other	Miscellaneous	0.900	0.21
2496	190	HTTP	Web	94.117	25.21
2497	190	HTTPS	Web	129.948	34.81
2498	190	YouTube	Video	55.600	14.89
2499	190	Netflix	Video	30.029	8.04
2500	190	WhatsApp	Messaging	11.639	3.12
2501	190	Facebook	Social	15.110	4.05
2502	190	Instagram	Social	11.769	3.15
2503	190	Spotify	Audio	7.358	1.97
2504	190	Teams	Business	6.940	1.86
2505	190	Zoom	Business	10.850	2.91
2506	191	HTTP	Web	107.829	25.19
2507	191	HTTPS	Web	148.881	34.77
2508	191	YouTube	Video	63.724	14.88
2509	191	Netflix	Video	34.076	7.96
2510	191	WhatsApp	Messaging	13.816	3.23
2511	191	Facebook	Social	17.049	3.98
2512	191	Instagram	Social	14.081	3.29
2513	191	Spotify	Audio	7.517	1.76
2514	191	Teams	Business	8.976	2.10
2515	191	Zoom	Business	12.079	2.82
2516	191	Other	Miscellaneous	0.113	0.03
2517	192	HTTP	Web	108.547	25.17
2518	192	HTTPS	Web	151.762	35.19
2519	192	YouTube	Video	64.106	14.87
2520	192	Netflix	Video	33.513	7.77
2521	192	WhatsApp	Messaging	13.908	3.23
2522	192	Facebook	Social	17.688	4.10
2523	192	Instagram	Social	11.678	2.71
2524	192	Spotify	Audio	9.861	2.29
2525	192	Teams	Business	8.173	1.90
2526	192	Zoom	Business	12.351	2.86
2527	193	HTTP	Web	100.013	24.91
2528	193	HTTPS	Web	141.671	35.28
2529	193	YouTube	Video	61.333	15.28
2530	193	Netflix	Video	31.608	7.87
2531	193	WhatsApp	Messaging	12.024	2.99
2532	193	Facebook	Social	15.728	3.92
2533	193	Instagram	Social	11.980	2.98
2534	193	Spotify	Audio	7.847	1.95
2535	193	Teams	Business	8.424	2.10
2536	193	Zoom	Business	13.225	3.29
\.


--
-- Data for Name: protocol_usage_backup; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.protocol_usage_backup (id, usage_record_id, protocol_name, category, usage_gb, percentage) FROM stdin;
\.


--
-- Data for Name: sim_numbers; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.sim_numbers (id, client_id, sim_number, created_at, msisdn, fup_gb) FROM stdin;
82	KWright0004	89270277240011345783	2025-08-15 10:15:20.864156	0715264751	50
83	E06815337298597	0681533729	2025-08-17 12:24:48.955456	89270200240406635808	100
84	H06584391207400	89270200240405059224	2025-08-18 08:32:59.800969	0658439120	350
85	H06583783261526	89270200240405059216	2025-08-18 09:14:41.517311	0658378326	350
86	H06779683579311	89270200240405059208	2025-08-18 09:17:58.952717	0677968357	350
87	H06956586880106	89270200240405059489	2025-08-18 09:20:29.278998	0695658688	350
88	D06932067823015	89270288240102647300	2025-08-18 13:32:54.253282	0693206782	150
89	C06915630140109	89270277240011346096	2025-08-18 13:36:25.813053	0691563014	300
90	W06974145455980	89270288220057299935	2025-08-19 05:31:55.76562	0697414545	300
91	C06915630140109	89270200240166222565	2025-08-19 05:41:39.567927	0672515927	120
93	J08138312825445	89270200240405059430	2025-08-19 06:54:01.533762	0813831282	150
94	J08152906270400	89270200240405059299	2025-08-19 14:24:10.975923	0815290627	100
95	A06800854228718	89270200240405059398	2025-08-20 06:15:33.926031	0680085422	350
96	K06149099815042	89270200230196643658	2025-08-20 14:37:05.678816	0614909981	200
97	N06940094359538	89270288230099917246	2025-08-21 15:07:59.472226	0694009435	50
\.


--
-- Data for Name: usage_records; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.usage_records (id, client_id, total_usage_gb, date_from, date_to, fup_reached, daily_breakdown, created_at, msisdn, sim_number) FROM stdin;
179	KWright0004	309.800	2025-08-01	2025-08-15	t	{"2025-08-01": 15.42, "2025-08-02": 24.33, "2025-08-03": 34.22, "2025-08-04": 16.95, "2025-08-05": 30.04, "2025-08-06": 33.61, "2025-08-07": 9.82, "2025-08-08": 5.91, "2025-08-09": 8.59, "2025-08-10": 16.62, "2025-08-11": 2.34, "2025-08-12": 21.61, "2025-08-13": 19.75, "2025-08-14": 33.4, "2025-08-15": 37.19}	2025-08-15 10:15:20.96922	0715264751	89270277240011345783
180	E06815337298597	389.510	2025-08-01	2025-08-17	t	{"2025-08-01": 3.04, "2025-08-02": 34.9, "2025-08-03": 10.62, "2025-08-04": 12.36, "2025-08-05": 36.78, "2025-08-06": 34.3, "2025-08-07": 20.22, "2025-08-08": 7.02, "2025-08-09": 24.33, "2025-08-10": 32.12, "2025-08-11": 6.82, "2025-08-12": 32.7, "2025-08-13": 31.28, "2025-08-14": 35.4, "2025-08-15": 34.54, "2025-08-16": 13.64, "2025-08-17": 19.44}	2025-08-17 12:24:49.063522	89270200240406635808	0681533729
181	H06584391207400	365.400	2025-08-01	2025-08-18	t	{"2025-08-01": 3.47, "2025-08-02": 24.16, "2025-08-03": 21.77, "2025-08-04": 6.42, "2025-08-05": 1.77, "2025-08-06": 14.05, "2025-08-07": 19.41, "2025-08-08": 27.53, "2025-08-09": 6.1, "2025-08-10": 14.63, "2025-08-11": 28.33, "2025-08-12": 28.44, "2025-08-13": 15.54, "2025-08-14": 31.35, "2025-08-15": 26.07, "2025-08-16": 29.68, "2025-08-17": 30.37, "2025-08-18": 36.31}	2025-08-18 08:32:59.914467	0658439120	89270200240405059224
182	H06583783261526	362.600	2025-08-01	2025-08-18	t	{"2025-08-01": 17.11, "2025-08-02": 14.86, "2025-08-03": 5.5, "2025-08-04": 11.81, "2025-08-05": 2.83, "2025-08-06": 19.72, "2025-08-07": 30.81, "2025-08-08": 23.64, "2025-08-09": 17.73, "2025-08-10": 20.91, "2025-08-11": 36.04, "2025-08-12": 18.18, "2025-08-13": 18.88, "2025-08-14": 2.04, "2025-08-15": 22.07, "2025-08-16": 34.12, "2025-08-17": 36.31, "2025-08-18": 30.04}	2025-08-18 09:14:41.631372	0658378326	89270200240405059216
183	H06779683579311	361.780	2025-08-01	2025-08-18	t	{"2025-08-01": 2.72, "2025-08-02": 26.33, "2025-08-03": 3.27, "2025-08-04": 23.86, "2025-08-05": 31.75, "2025-08-06": 28.46, "2025-08-07": 24.73, "2025-08-08": 30.0, "2025-08-09": 14.83, "2025-08-10": 12.23, "2025-08-11": 14.51, "2025-08-12": 26.92, "2025-08-13": 1.67, "2025-08-14": 27.36, "2025-08-15": 37.58, "2025-08-16": 4.22, "2025-08-17": 18.12, "2025-08-18": 33.22}	2025-08-18 09:17:59.065696	0677968357	89270200240405059208
184	H06956586880106	365.420	2025-08-01	2025-08-18	t	{"2025-08-01": 14.89, "2025-08-02": 33.25, "2025-08-03": 17.98, "2025-08-04": 11.94, "2025-08-05": 34.5, "2025-08-06": 36.51, "2025-08-07": 16.48, "2025-08-08": 24.57, "2025-08-09": 8.55, "2025-08-10": 11.75, "2025-08-11": 7.68, "2025-08-12": 29.28, "2025-08-13": 22.79, "2025-08-14": 28.01, "2025-08-15": 26.18, "2025-08-16": 16.4, "2025-08-17": 15.82, "2025-08-18": 8.84}	2025-08-18 09:20:29.391784	0695658688	89270200240405059489
185	D06932067823015	346.200	2025-08-01	2025-08-18	t	{"2025-08-01": 14.49, "2025-08-02": 22.77, "2025-08-03": 23.76, "2025-08-04": 16.45, "2025-08-05": 7.36, "2025-08-06": 31.06, "2025-08-07": 36.53, "2025-08-08": 29.7, "2025-08-09": 9.67, "2025-08-10": 29.95, "2025-08-11": 22.61, "2025-08-12": 11.32, "2025-08-13": 11.14, "2025-08-14": 1.04, "2025-08-15": 27.44, "2025-08-16": 26.68, "2025-08-17": 9.93, "2025-08-18": 14.3}	2025-08-18 13:32:54.361681	0693206782	89270288240102647300
186	C06915630140109	337.040	2025-08-01	2025-08-18	t	{"2025-08-01": 18.91, "2025-08-02": 3.83, "2025-08-03": 21.2, "2025-08-04": 6.52, "2025-08-05": 29.85, "2025-08-06": 31.23, "2025-08-07": 14.68, "2025-08-08": 8.32, "2025-08-09": 13.03, "2025-08-10": 9.86, "2025-08-11": 26.06, "2025-08-12": 18.77, "2025-08-13": 9.55, "2025-08-14": 21.59, "2025-08-15": 24.41, "2025-08-16": 31.9, "2025-08-17": 25.76, "2025-08-18": 21.57}	2025-08-18 13:36:25.921584	0691563014	89270277240011346096
187	W06974145455980	457.400	2025-08-01	2025-08-19	t	{"2025-08-01": 27.9, "2025-08-02": 28.83, "2025-08-03": 25.58, "2025-08-04": 16.74, "2025-08-05": 19.4, "2025-08-06": 19.88, "2025-08-07": 8.22, "2025-08-08": 29.83, "2025-08-09": 21.93, "2025-08-10": 26.74, "2025-08-11": 22.81, "2025-08-12": 30.59, "2025-08-13": 14.0, "2025-08-14": 30.86, "2025-08-15": 26.51, "2025-08-16": 17.05, "2025-08-17": 36.57, "2025-08-18": 18.17, "2025-08-19": 35.79}	2025-08-19 05:31:55.879278	0697414545	89270288220057299935
188	C06915630140109	381.480	2025-08-01	2025-08-19	t	{"2025-08-01": 22.23, "2025-08-02": 13.23, "2025-08-03": 21.21, "2025-08-04": 30.58, "2025-08-05": 23.45, "2025-08-06": 1.29, "2025-08-07": 10.32, "2025-08-08": 17.02, "2025-08-09": 13.3, "2025-08-10": 18.72, "2025-08-11": 21.31, "2025-08-12": 37.53, "2025-08-13": 2.66, "2025-08-14": 33.02, "2025-08-15": 19.69, "2025-08-16": 29.08, "2025-08-17": 32.83, "2025-08-18": 14.28, "2025-08-19": 19.73}	2025-08-19 05:41:39.677376	0672515927	89270200240166222565
189	J08138312825445	434.060	2025-08-01	2025-08-19	t	{"2025-08-01": 24.8, "2025-08-02": 34.21, "2025-08-03": 23.99, "2025-08-04": 18.23, "2025-08-05": 13.3, "2025-08-06": 22.6, "2025-08-07": 24.78, "2025-08-08": 20.78, "2025-08-09": 30.63, "2025-08-10": 9.61, "2025-08-11": 27.14, "2025-08-12": 28.4, "2025-08-13": 20.9, "2025-08-14": 21.93, "2025-08-15": 32.7, "2025-08-16": 14.99, "2025-08-17": 26.37, "2025-08-18": 27.23, "2025-08-19": 11.47}	2025-08-19 06:54:01.64003	0813831282	89270200240405059430
190	J08152906270400	373.280	2025-08-01	2025-08-19	t	{"2025-08-01": 21.03, "2025-08-02": 14.62, "2025-08-03": 14.45, "2025-08-04": 8.09, "2025-08-05": 16.25, "2025-08-06": 1.85, "2025-08-07": 12.32, "2025-08-08": 18.61, "2025-08-09": 9.29, "2025-08-10": 32.72, "2025-08-11": 32.88, "2025-08-12": 2.03, "2025-08-13": 28.79, "2025-08-14": 31.44, "2025-08-15": 31.21, "2025-08-16": 37.54, "2025-08-17": 19.69, "2025-08-18": 10.78, "2025-08-19": 29.69}	2025-08-19 14:24:11.088227	0815290627	89270200240405059299
191	A06800854228718	428.140	2025-08-01	2025-08-20	t	{"2025-08-01": 37.17, "2025-08-02": 22.86, "2025-08-03": 28.82, "2025-08-04": 25.33, "2025-08-05": 7.81, "2025-08-06": 4.63, "2025-08-07": 18.88, "2025-08-08": 12.8, "2025-08-09": 32.99, "2025-08-10": 13.6, "2025-08-11": 18.81, "2025-08-12": 33.56, "2025-08-13": 30.04, "2025-08-14": 25.74, "2025-08-15": 15.81, "2025-08-16": 14.08, "2025-08-17": 14.92, "2025-08-18": 27.34, "2025-08-19": 18.67, "2025-08-20": 24.28}	2025-08-20 06:15:34.05542	0680085422	89270200240405059398
192	K06149099815042	431.220	2025-08-01	2025-08-20	t	{"2025-08-01": 34.87, "2025-08-02": 17.8, "2025-08-03": 16.34, "2025-08-04": 22.83, "2025-08-05": 32.51, "2025-08-06": 12.72, "2025-08-07": 5.57, "2025-08-08": 19.39, "2025-08-09": 16.53, "2025-08-10": 31.83, "2025-08-11": 14.13, "2025-08-12": 30.87, "2025-08-13": 19.7, "2025-08-14": 10.17, "2025-08-15": 28.57, "2025-08-16": 14.49, "2025-08-17": 32.71, "2025-08-18": 14.85, "2025-08-19": 33.94, "2025-08-20": 21.4}	2025-08-20 14:37:05.781999	0614909981	89270200230196643658
193	N06940094359538	401.510	2025-08-01	2025-08-21	t	{"2025-08-01": 22.26, "2025-08-02": 31.4, "2025-08-03": 15.89, "2025-08-04": 26.64, "2025-08-05": 1.88, "2025-08-06": 20.69, "2025-08-07": 28.79, "2025-08-08": 21.93, "2025-08-09": 3.33, "2025-08-10": 15.31, "2025-08-11": 28.35, "2025-08-12": 37.52, "2025-08-13": 20.9, "2025-08-14": 21.33, "2025-08-15": 14.41, "2025-08-16": 8.6, "2025-08-17": 11.57, "2025-08-18": 33.47, "2025-08-19": 8.03, "2025-08-20": 2.87, "2025-08-21": 26.34}	2025-08-21 15:07:59.580959	0694009435	89270288230099917246
\.


--
-- Data for Name: usage_records_backup; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.usage_records_backup (id, client_id, total_usage_gb, date_from, date_to, fup_reached, daily_breakdown, created_at, msisdn, sim_number) FROM stdin;
\.


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.users (id, username, password_hash, role, created_at, last_login, is_active) FROM stdin;
1	admin	240be518fabd2724ddb6f04eeb1da5967448d7e831c08c8fa822809f74c720a9	admin	2025-06-19 11:48:02.96562	\N	f
4	ceo@openweb.email	3455d2016bd6ac8f41cf6b17a4b066f14b663aa5c579737b3b139c87c114d05a	staff	2025-06-19 12:00:07.811586	2025-06-19 12:30:15.600845	t
3	ceo@openweb.co.za	3455d2016bd6ac8f41cf6b17a4b066f14b663aa5c579737b3b139c87c114d05a	admin	2025-06-19 11:59:58.452586	2025-08-15 11:59:28.086307	t
6	dane@openweb.co.za	21e670c249bcb8a3b3d35ae28788eed8987f1b2a8ee57747bcadfdad66f39540	staff	2025-06-26 10:13:30.108492	2025-08-20 14:36:00.024857	t
5	zelda@openweb.co.za	53b2b3327873de1f6efc2a56e637ed879b4c412edea9bd310c469e0cd1543f2f	staff	2025-06-19 12:30:59.313447	2025-08-21 15:05:33.774307	t
2	staff	10176e7b7b24d317acfcf8d2064cfd2f24e154f7b5a96603077d5ef813d6a6b6	staff	2025-06-19 11:48:02.96562	\N	f
\.


--
-- Name: api_keys_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.api_keys_id_seq', 1, false);


--
-- Name: api_usage_logs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.api_usage_logs_id_seq', 1, false);


--
-- Name: daily_usage_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.daily_usage_id_seq', 18, true);


--
-- Name: protocol_usage_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.protocol_usage_id_seq', 2536, true);


--
-- Name: sim_numbers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.sim_numbers_id_seq', 97, true);


--
-- Name: usage_records_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.usage_records_id_seq', 193, true);


--
-- Name: users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.users_id_seq', 6, true);


--
-- Name: api_keys api_keys_api_key_hash_key; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_keys
    ADD CONSTRAINT api_keys_api_key_hash_key UNIQUE (api_key_hash);


--
-- Name: api_keys api_keys_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_keys
    ADD CONSTRAINT api_keys_pkey PRIMARY KEY (id);


--
-- Name: api_usage_logs api_usage_logs_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_usage_logs
    ADD CONSTRAINT api_usage_logs_pkey PRIMARY KEY (id);


--
-- Name: clients clients_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.clients
    ADD CONSTRAINT clients_pkey PRIMARY KEY (client_id);


--
-- Name: daily_usage daily_usage_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.daily_usage
    ADD CONSTRAINT daily_usage_pkey PRIMARY KEY (id);


--
-- Name: protocol_usage protocol_usage_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.protocol_usage
    ADD CONSTRAINT protocol_usage_pkey PRIMARY KEY (id);


--
-- Name: sim_numbers sim_numbers_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.sim_numbers
    ADD CONSTRAINT sim_numbers_pkey PRIMARY KEY (id);


--
-- Name: sim_numbers sim_numbers_sim_number_key; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.sim_numbers
    ADD CONSTRAINT sim_numbers_sim_number_key UNIQUE (sim_number);


--
-- Name: usage_records usage_records_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.usage_records
    ADD CONSTRAINT usage_records_pkey PRIMARY KEY (id);


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: users users_username_key; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_username_key UNIQUE (username);


--
-- Name: api_usage_logs api_usage_logs_api_key_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.api_usage_logs
    ADD CONSTRAINT api_usage_logs_api_key_id_fkey FOREIGN KEY (api_key_id) REFERENCES public.api_keys(id);


--
-- Name: daily_usage daily_usage_usage_record_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.daily_usage
    ADD CONSTRAINT daily_usage_usage_record_id_fkey FOREIGN KEY (usage_record_id) REFERENCES public.usage_records(id);


--
-- Name: protocol_usage protocol_usage_usage_record_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.protocol_usage
    ADD CONSTRAINT protocol_usage_usage_record_id_fkey FOREIGN KEY (usage_record_id) REFERENCES public.usage_records(id);


--
-- Name: sim_numbers sim_numbers_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.sim_numbers
    ADD CONSTRAINT sim_numbers_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.clients(client_id) ON DELETE CASCADE;


--
-- Name: usage_records usage_records_client_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.usage_records
    ADD CONSTRAINT usage_records_client_id_fkey FOREIGN KEY (client_id) REFERENCES public.clients(client_id);


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: public; Owner: cloud_admin
--

ALTER DEFAULT PRIVILEGES FOR ROLE cloud_admin IN SCHEMA public GRANT ALL ON SEQUENCES TO neon_superuser WITH GRANT OPTION;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: public; Owner: cloud_admin
--

ALTER DEFAULT PRIVILEGES FOR ROLE cloud_admin IN SCHEMA public GRANT ALL ON TABLES TO neon_superuser WITH GRANT OPTION;


--
-- PostgreSQL database dump complete
--

