# StaffAccess Android App

This directory contains the native Android application for StaffAccess - YouTube Channel Manager.

## App Information
- **App Name**: StaffAccess
- **Package ID**: com.staffaccess.app
- **Platform**: Android (API 22+)
- **Build System**: Gradle

## Project Structure
```
android/
├── app/                          # Main Android application
│   ├── src/main/
│   │   ├── assets/public/        # Web app assets (auto-generated)
│   │   ├── java/                 # Java/Kotlin source code
│   │   ├── res/                  # Android resources
│   │   └── AndroidManifest.xml   # App manifest
│   └── build.gradle             # App-level build configuration
├── gradle/                      # Gradle wrapper
├── build.gradle                 # Project-level build configuration
└── settings.gradle              # Project settings
```

## Building the App

### Prerequisites
- Android Studio or Android SDK
- Java 11 or higher
- Gradle (included via wrapper)

### Debug Build
```bash
# From the android directory
./gradlew assembleDebug
```
The APK will be generated at: `app/build/outputs/apk/debug/app-debug.apk`

### Release Build
```bash
# From the android directory
./gradlew assembleRelease
```
The APK will be generated at: `app/build/outputs/apk/release/app-release.apk`

### Installing on Device
```bash
# Connect Android device via USB with USB debugging enabled
adb install app/build/outputs/apk/debug/app-debug.apk
```

## Development Workflow

### Updating Web Assets
When you make changes to your web application:

1. Build the web app (from project root):
   ```bash
   vite build
   ```

2. Copy assets to Android:
   ```bash
   npx cap copy android
   ```

3. Sync plugins and dependencies:
   ```bash
   npx cap sync android
   ```

### Opening in Android Studio
```bash
# From project root
npx cap open android
```

## App Features
- Launches the StaffAccess web application
- Professional Google Material Design UI
- Automatic redirect to web portal
- Native Android integration
- Optimized for mobile devices

## Configuration
The app configuration is managed through:
- `capacitor.config.ts` (main configuration)
- `android/app/src/main/res/values/strings.xml` (app strings)
- `android/app/src/main/AndroidManifest.xml` (permissions and metadata)

## Notes
- The app serves as a launcher for the web-based StaffAccess portal
- All core functionality runs through the responsive web interface
- No breaking changes were made to the existing codebase
- The Android app automatically opens the web application in the user's browser