## API

|     |     |
| --- | --- |
| HTTP Method | POST |
| API URL | https://smmcost.com/api/v2 |
| Response format | JSON |

#### Service list

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | services |

###### Example response

```
[\
    {\
        "service": 1,\
        "name": "Followers",\
        "type": "Default",\
        "category": "First Category",\
        "rate": "0.90",\
        "min": "50",\
        "max": "10000",\
        "refill": true,\
        "cancel": true\
    },\
    {\
        "service": 2,\
        "name": "Comments",\
        "type": "Custom Comments",\
        "category": "Second Category",\
        "rate": "8",\
        "min": "10",\
        "max": "1500",\
        "refill": false,\
        "cancel": true\
    }\
]

```

#### Add order

DefaultPackageCustom CommentsMentions with HashtagsMentions Custom ListMentions HashtagMentions User FollowersMentions Media LikersCustom Comments PackageComment LikesPollInvites from GroupsSubscriptions

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| runs (optional) | Runs to deliver |
| interval (optional) | Interval in minutes |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| comments | Comments list separated by \\r\\n or \\n |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| usernames | Usernames list separated by \\r\\n or \\n |
| hashtags | Hashtags list separated by \\r\\n or \\n |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| usernames | Usernames list separated by \\r\\n or \\n |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| hashtag | Hashtag to scrape usernames from |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| username | URL to scrape followers from |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| media | Media URL to scrape likers from |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| username | Username |
| min | Quantity min |
| max | Quantity max |
| posts (optional) | Use this parameter if you want to limit the number of new (future) posts that will be parsed and for which orders will be created. If posts parameter is not set, the subscription will be created for an unlimited number of posts. |
| old\_posts (optional) | Number of existing posts that will be parsed and for which orders will be created, can be used if this option is available for the service. |
| delay | Delay in minutes. Possible values: 0, 5, 10, 15, 20, 30, 40, 50, 60, 90, 120, 150, 180, 210, 240, 270, 300, 360, 420, 480, 540, 600 |
| expiry (optional) | Expiry date. Format d/m/Y |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| comments | Comments list separated by \\r\\n or \\n |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| username | Username of the comment owner |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| answer\_number | Answer number of the poll |

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | add |
| service | Service ID |
| link | Link to page |
| quantity | Needed quantity |
| groups | Groups list separated by \\r\\n or \\n |

###### Example response

```
{
    "order": 23501
}

```

#### Order status

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | status |
| order | Order ID |

###### Example response

```
{
    "charge": "0.27819",
    "start_count": "3572",
    "status": "Partial",
    "remains": "157",
    "currency": "USD"
}

```

#### Multiple orders status

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | status |
| orders | Order IDs (separated by a comma, up to 100 IDs) |

###### Example response

```
{
    "1": {
        "charge": "0.27819",
        "start_count": "3572",
        "status": "Partial",
        "remains": "157",
        "currency": "USD"
    },
    "10": {
        "error": "Incorrect order ID"
    },
    "100": {
        "charge": "1.44219",
        "start_count": "234",
        "status": "In progress",
        "remains": "10",
        "currency": "USD"
    }
}

```

#### Create refill

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | refill |
| order | Order ID |

###### Example response

```
{
    "refill": "1"
}

```

#### Create multiple refill

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | refill |
| orders | Order IDs (separated by a comma, up to 100 IDs) |

###### Example response

```
[\
    {\
        "order": 1,\
        "refill": 1\
    },\
    {\
        "order": 2,\
        "refill": 2\
    },\
    {\
        "order": 3,\
        "refill": {\
            "error": "Incorrect order ID"\
        }\
    }\
]

```

#### Get refill status

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | refill\_status |
| refill | Refill ID |

###### Example response

```
{
    "status": "Completed"
}

```

#### Get multiple refill status

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | refill\_status |
| refills | Refill IDs (separated by a comma, up to 100 IDs) |

###### Example response

```
[\
    {\
        "refill": 1,\
        "status": "Completed"\
    },\
    {\
        "refill": 2,\
        "status": "Rejected"\
    },\
    {\
        "refill": 3,\
        "status": {\
            "error": "Refill not found"\
        }\
    }\
]

```

#### Create cancel

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | cancel |
| orders | Order IDs (separated by a comma, up to 100 IDs) |

###### Example response

```
[\
    {\
        "order": 9,\
        "cancel": {\
            "error": "Incorrect order ID"\
        }\
    },\
    {\
        "order": 2,\
        "cancel": 1\
    }\
]

```

#### User balance

| Parameters | Description |
| --- | --- |
| key | Your API key |
| action | balance |

###### Example response

```
{
    "balance": "100.84292",
    "currency": "USD"
}

```

[Example of PHP code](https://smmcost.com/example.txt)