import { useQuery } from "@tanstack/react-query";
import { apiRequest } from "@/lib/queryClient";
import { useEffect } from "react";
import type { HeaderCode } from "@shared/schema";

export default function HeaderCodesRenderer() {
  const { data: headerCodes = [] } = useQuery<HeaderCode[]>({
    queryKey: ["/api/active-header-codes"],
    queryFn: () => apiRequest("/api/active-header-codes"),
  });

  useEffect(() => {
    // Clear existing header codes
    const existingCodes = document.querySelectorAll('[data-header-code]');
    existingCodes.forEach(el => el.remove());

    // Add new header codes
    headerCodes.forEach((headerCode) => {
      const script = document.createElement('script');
      script.innerHTML = headerCode.code;
      script.setAttribute('data-header-code', headerCode.id.toString());
      document.head.appendChild(script);
    });
  }, [headerCodes]);

  return null;
}