import { useState } from "react";
import { useQuery } from "@tanstack/react-query";
import InsufficientPointsModal from "@/components/InsufficientPointsModal";

export function useInsufficientPoints() {
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [modalConfig, setModalConfig] = useState({
    requiredPoints: 0,
    currentPoints: 0
  });

  const { data: pointsData, refetch } = useQuery({
    queryKey: ["/api/points"],
    refetchInterval: 30000
  });

  const checkAndShowModal = (requiredPoints: number) => {
    const currentPoints = (pointsData?.remainingPoints || 0) + (pointsData?.purchasedPoints || 0);
    
    if (currentPoints < requiredPoints) {
      setModalConfig({
        requiredPoints,
        currentPoints
      });
      setIsModalOpen(true);
      return false; // Insufficient points
    }
    
    return true; // Sufficient points
  };

  const handleSuccess = () => {
    refetch(); // Refresh points after successful purchase
    setIsModalOpen(false);
  };

  const InsufficientPointsModalComponent = () => (
    <InsufficientPointsModal
      isOpen={isModalOpen}
      onClose={() => setIsModalOpen(false)}
      requiredPoints={modalConfig.requiredPoints}
      currentPoints={modalConfig.currentPoints}
      onSuccess={handleSuccess}
    />
  );

  return {
    checkAndShowModal,
    InsufficientPointsModalComponent,
    currentPoints: (pointsData?.remainingPoints || 0) + (pointsData?.purchasedPoints || 0)
  };
}