import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { Separator } from "@/components/ui/separator";
import { 
  Youtube, 
  TrendingUp, 
  Shield, 
  Zap, 
  Users, 
  Star, 
  CheckCircle, 
  Target,
  BarChart3,
  Brain,
  Globe,
  Lock
} from "lucide-react";
import { Link } from "wouter";

export default function About() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 via-white to-purple-50 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900">
      {/* Navigation */}
      <nav className="bg-white/80 dark:bg-gray-900/80 backdrop-blur-md border-b border-gray-200 dark:border-gray-700 sticky top-0 z-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex justify-between items-center h-16">
            <div className="flex items-center space-x-2">
              <Youtube className="w-8 h-8 text-red-600" />
              <span className="text-2xl font-bold bg-gradient-to-r from-red-600 to-purple-600 bg-clip-text text-transparent">
                TubeBoost
              </span>
            </div>
            <div className="flex items-center space-x-4">
              <Link href="/">
                <Button variant="ghost" className="text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white">
                  Home
                </Button>
              </Link>
              <Link href="/login">
                <Button className="bg-gradient-to-r from-red-600 to-purple-600 text-white hover:from-red-700 hover:to-purple-700">
                  Get Started
                </Button>
              </Link>
            </div>
          </div>
        </div>
      </nav>

      {/* Hero Section */}
      <section className="py-20 px-4 text-center">
        <div className="max-w-4xl mx-auto">
          <Badge className="mb-4 bg-gradient-to-r from-red-100 to-purple-100 text-red-800 dark:from-red-900 dark:to-purple-900 dark:text-red-200">
            About TubeBoost
          </Badge>
          <h1 className="text-5xl md:text-6xl font-bold mb-6 bg-gradient-to-r from-red-600 via-purple-600 to-blue-600 bg-clip-text text-transparent">
            Professional YouTube Growth & Social Media Management Platform
          </h1>
          <p className="text-xl text-gray-600 dark:text-gray-300 mb-8 leading-relaxed">
            TubeBoost is the leading YouTube channel management platform that combines AI-powered video optimization, legitimate subscriber growth services, advanced YouTube analytics, and professional social media marketing tools to help content creators grow their channels, increase views, and maximize revenue through data-driven strategies.
          </p>
        </div>
      </section>

      {/* Mission & Vision */}
      <section className="py-16 px-4">
        <div className="max-w-6xl mx-auto">
          <div className="grid md:grid-cols-2 gap-8">
            <Card className="bg-white/50 dark:bg-gray-800/50 backdrop-blur-sm border-0 shadow-xl">
              <CardHeader>
                <CardTitle className="flex items-center space-x-2 text-2xl">
                  <Target className="w-6 h-6 text-red-600" />
                  <span>Our Mission</span>
                </CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-gray-600 dark:text-gray-300 leading-relaxed">
                  To democratize YouTube success by providing content creators with professional-grade 
                  YouTube marketing tools, AI-powered video optimization, and legitimate subscriber growth services that were previously 
                  only available to major content studios and influencer marketing agencies. We help YouTubers grow their channels organically.
                </p>
              </CardContent>
            </Card>

            <Card className="bg-white/50 dark:bg-gray-800/50 backdrop-blur-sm border-0 shadow-xl">
              <CardHeader>
                <CardTitle className="flex items-center space-x-2 text-2xl">
                  <Globe className="w-6 h-6 text-purple-600" />
                  <span>Our Vision</span>
                </CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-gray-600 dark:text-gray-300 leading-relaxed">
                  To become the world's leading YouTube growth platform, empowering millions 
                  of creators to build sustainable, profitable channels while maintaining 
                  authenticity and community trust.
                </p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Key Features */}
      <section className="py-16 px-4 bg-white/30 dark:bg-gray-800/30">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold mb-4 text-gray-900 dark:text-white">
              Why Choose TubeBoost?
            </h2>
            <p className="text-xl text-gray-600 dark:text-gray-300">
              Comprehensive tools designed for serious YouTube creators
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            <Card className="bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm border-0 shadow-xl hover:shadow-2xl transition-all duration-300">
              <CardHeader>
                <Brain className="w-12 h-12 text-blue-600 mb-4" />
                <CardTitle className="text-xl">AI-Powered Optimization</CardTitle>
                <CardDescription>
                  Advanced OpenWeb 3.2 AI analyzes your content and provides personalized 
                  optimization strategies based on YouTube's algorithm patterns.
                </CardDescription>
              </CardHeader>
            </Card>

            <Card className="bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm border-0 shadow-xl hover:shadow-2xl transition-all duration-300">
              <CardHeader>
                <TrendingUp className="w-12 h-12 text-green-600 mb-4" />
                <CardTitle className="text-xl">Professional Growth Services</CardTitle>
                <CardDescription>
                  Legitimate view and subscriber boost services through our verified 
                  partner network, ensuring safe and sustainable channel growth.
                </CardDescription>
              </CardHeader>
            </Card>

            <Card className="bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm border-0 shadow-xl hover:shadow-2xl transition-all duration-300">
              <CardHeader>
                <BarChart3 className="w-12 h-12 text-purple-600 mb-4" />
                <CardTitle className="text-xl">Advanced Analytics</CardTitle>
                <CardDescription>
                  Comprehensive performance tracking, competitor analysis, and 
                  detailed insights to guide your content strategy decisions.
                </CardDescription>
              </CardHeader>
            </Card>

            <Card className="bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm border-0 shadow-xl hover:shadow-2xl transition-all duration-300">
              <CardHeader>
                <Shield className="w-12 h-12 text-red-600 mb-4" />
                <CardTitle className="text-xl">Enterprise Security</CardTitle>
                <CardDescription>
                  Advanced fraud prevention, device fingerprinting, and multi-layer 
                  security systems to protect your account and ensure fair usage.
                </CardDescription>
              </CardHeader>
            </Card>

            <Card className="bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm border-0 shadow-xl hover:shadow-2xl transition-all duration-300">
              <CardHeader>
                <Users className="w-12 h-12 text-orange-600 mb-4" />
                <CardTitle className="text-xl">Multi-Channel Management</CardTitle>
                <CardDescription>
                  Manage multiple YouTube channels from a single dashboard with 
                  team collaboration features and role-based access controls.
                </CardDescription>
              </CardHeader>
            </Card>

            <Card className="bg-white/70 dark:bg-gray-800/70 backdrop-blur-sm border-0 shadow-xl hover:shadow-2xl transition-all duration-300">
              <CardHeader>
                <Zap className="w-12 h-12 text-yellow-600 mb-4" />
                <CardTitle className="text-xl">Real-Time Monitoring</CardTitle>
                <CardDescription>
                  Live order tracking, instant notifications, and real-time 
                  performance updates to keep you informed of your channel's progress.
                </CardDescription>
              </CardHeader>
            </Card>
          </div>
        </div>
      </section>

      {/* Technology Stack */}
      <section className="py-16 px-4">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold mb-4 text-gray-900 dark:text-white">
              Built with Cutting-Edge Technology
            </h2>
            <p className="text-xl text-gray-600 dark:text-gray-300">
              Enterprise-grade infrastructure for reliable, scalable performance
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            <Card className="bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-900 dark:to-blue-800 border-0">
              <CardContent className="p-6 text-center">
                <h3 className="font-semibold text-blue-900 dark:text-blue-100 mb-2">AI & Machine Learning</h3>
                <p className="text-sm text-blue-700 dark:text-blue-200">Claude Sonnet, Advanced Analytics</p>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900 dark:to-green-800 border-0">
              <CardContent className="p-6 text-center">
                <h3 className="font-semibold text-green-900 dark:text-green-100 mb-2">Backend Infrastructure</h3>
                <p className="text-sm text-green-700 dark:text-green-200">Node.js, TypeScript, PostgreSQL</p>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-purple-50 to-purple-100 dark:from-purple-900 dark:to-purple-800 border-0">
              <CardContent className="p-6 text-center">
                <h3 className="font-semibold text-purple-900 dark:text-purple-100 mb-2">Frontend Experience</h3>
                <p className="text-sm text-purple-700 dark:text-purple-200">React, Tailwind CSS, Real-time UI</p>
              </CardContent>
            </Card>

            <Card className="bg-gradient-to-br from-red-50 to-red-100 dark:from-red-900 dark:to-red-800 border-0">
              <CardContent className="p-6 text-center">
                <h3 className="font-semibold text-red-900 dark:text-red-100 mb-2">Security & Privacy</h3>
                <p className="text-sm text-red-700 dark:text-red-200">End-to-end Encryption, Device Fingerprinting</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Our Commitment */}
      <section className="py-16 px-4 bg-white/30 dark:bg-gray-800/30">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-4xl font-bold mb-8 text-gray-900 dark:text-white">
            Our Commitment to Creators
          </h2>
          
          <div className="grid md:grid-cols-3 gap-8">
            <div className="flex flex-col items-center">
              <CheckCircle className="w-12 h-12 text-green-600 mb-4" />
              <h3 className="text-xl font-semibold mb-2 text-gray-900 dark:text-white">100% Legitimate Services</h3>
              <p className="text-gray-600 dark:text-gray-300">
                All growth services comply with YouTube's Terms of Service
              </p>
            </div>

            <div className="flex flex-col items-center">
              <Lock className="w-12 h-12 text-blue-600 mb-4" />
              <h3 className="text-xl font-semibold mb-2 text-gray-900 dark:text-white">Data Privacy First</h3>
              <p className="text-gray-600 dark:text-gray-300">
                Your channel data is encrypted and never shared with third parties
              </p>
            </div>

            <div className="flex flex-col items-center">
              <Star className="w-12 h-12 text-yellow-600 mb-4" />
              <h3 className="text-xl font-semibold mb-2 text-gray-900 dark:text-white">24/7 Creator Support</h3>
              <p className="text-gray-600 dark:text-gray-300">
                Dedicated support team available around the clock
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-20 px-4">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-4xl font-bold mb-6 text-gray-900 dark:text-white">
            Ready to Transform Your YouTube Channel?
          </h2>
          <p className="text-xl text-gray-600 dark:text-gray-300 mb-8">
            Join thousands of successful creators who trust TubeBoost to accelerate their growth
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link href="/">
              <Button size="lg" className="bg-gradient-to-r from-red-600 to-purple-600 text-white hover:from-red-700 hover:to-purple-700 px-8 py-3">
                Start Free Trial
              </Button>
            </Link>
            <Link href="/">
              <Button size="lg" variant="outline" className="border-gray-300 text-gray-700 hover:bg-gray-50 dark:border-gray-600 dark:text-gray-300 dark:hover:bg-gray-800 px-8 py-3">
                View Pricing
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-gray-900 dark:bg-black text-white py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <div className="flex items-center space-x-2 mb-4 md:mb-0">
              <Youtube className="w-8 h-8 text-red-600" />
              <span className="text-2xl font-bold">TubeBoost</span>
            </div>
            
            <div className="flex items-center space-x-6 text-sm text-gray-400">
              <span>Production Domain: tubeboost.cc</span>
              <Separator orientation="vertical" className="h-4" />
              <span>© 2025 TubeBoost. All rights reserved.</span>
            </div>
          </div>
        </div>
      </footer>
    </div>
  );
}