// Quick script to activate Anthropic AI configuration

import { storage } from './storage.js';

export async function activateAnthropicConfig() {
  try {
    console.log('🔍 Checking AI configurations...');
    
    // Get all configurations
    const configs = await storage.getAiConfigurations();
    console.log(`Found ${configs.length} AI configurations`);
    
    // Find Anthropic configuration
    const anthropicConfig = configs.find(c => c.provider === 'anthropic');
    
    if (anthropicConfig) {
      console.log(`Found Anthropic config (ID: ${anthropicConfig.id})`);
      
      // Check if already active
      if (anthropicConfig.isActive) {
        console.log('✅ Anthropic config is already active');
        return true;
      }
      
      // Activate it
      await storage.setActiveAiConfiguration(anthropicConfig.id);
      console.log('✅ Activated Anthropic AI configuration');
      return true;
    } else {
      console.log('❌ No Anthropic configuration found');
      
      // Create a new Anthropic configuration
      const newConfig = await storage.createAiConfiguration({
        name: 'Claude Sonnet 4', // Add required name field
        provider: 'anthropic',
        model: 'claude-3-5-sonnet-20241022',
        maxTokens: 4000,
        temperature: 0.1,
        topP: 0.9,
        isActive: true,
        systemPrompt: 'You are an AI assistant specialized in content moderation.',
        createdBy: 2 // Add required createdBy field (user ID from logs)
      });
      
      console.log('✅ Created and activated new Anthropic configuration');
      return true;
    }
  } catch (error) {
    console.error('❌ Failed to activate Anthropic config:', error);
    return false;
  }
}

// Auto-run if called directly
if (import.meta.url === `file://${process.argv[1]}`) {
  activateAnthropicConfig();
}