import axios from 'axios';

async function testAIAnalysis() {
  const baseURL = 'http://localhost:5000';
  
  // First login to get session
  const loginResponse = await axios.post(`${baseURL}/api/login`, {
    emailOrUsername: 'kwright@staffaccess.space',
    password: 'Maniac20!'
  });
  
  console.log('Login status:', loginResponse.status);
  const sessionCookie = loginResponse.headers['set-cookie']?.[0];
  
  if (!sessionCookie) {
    console.error('No session cookie received');
    return;
  }
  
  // Extract session ID from cookie
  const sessionId = sessionCookie.split('=')[1].split(';')[0];
  console.log('Session ID:', sessionId);
  
  // Test AI analysis with proper authentication
  const testData = {
    subreddit: 'mildlyinterestingmods',
    itemId: 'test123',
    itemData: {
      id: 'test123',
      fullname: 't3_test123',
      type: 'submission',
      author: 'testuser',
      title: 'Test meme post that should be flagged',
      content: 'This is a banana for scale meme that violates rules',
      permalink: '/r/mildlyinterestingmods/comments/test123/test_post/',
      score: 10,
      numReports: 1,
      userReports: [['No Memes', 1, false, false]],
      modReports: [],
      created: '2025-06-29T15:00:00.000Z'
    }
  };
  
  try {
    // First fetch subreddit rules
    console.log('Fetching subreddit rules...');
    const rulesResponse = await axios.get(
      `${baseURL}/api/reddit/subreddit/mildlyinterestingmods/rules`,
      {
        headers: {
          'Cookie': `sessionId=${sessionId}`
        }
      }
    );
    
    console.log('Rules fetched successfully:', rulesResponse.status);
    
    // Now run AI analysis
    console.log('Running AI analysis...');
    const analysisResponse = await axios.post(
      `${baseURL}/api/reddit/analyze-modqueue-item`,
      testData,
      {
        headers: {
          'Cookie': `sessionId=${sessionId}`,
          'Content-Type': 'application/json'
        }
      }
    );
    
    console.log('AI Analysis Response Status:', analysisResponse.status);
    console.log('AI Analysis Result:', JSON.stringify(analysisResponse.data, null, 2));
    
  } catch (error) {
    console.error('AI Analysis Error:', error.response?.status, error.response?.data);
    console.error('Full error:', error.message);
  }
}

testAIAnalysis().catch(console.error);